/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.core;

import lucraft.mods.lucraftcore.core.LucraftCoreCoreMod;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class LCTransformer
implements IClassTransformer,
Opcodes {
    public byte[] transform(String name, String transformedName, byte[] classBytes) {
        if (transformedName.equals("net.minecraft.client.renderer.entity.RenderLivingBase")) {
            return LCTransformer.patchRenderLivingBase(name, classBytes, false);
        }
        if (transformedName.equals("net.minecraft.client.model.ModelBiped")) {
            return LCTransformer.patchModelBiped(name, classBytes, false);
        }
        if (transformedName.equals("net.minecraft.client.Minecraft")) {
            return LCTransformer.patchMinecraft(name, classBytes, false);
        }
        if (transformedName.equals("net.minecraft.entity.Entity")) {
            return LCTransformer.patchEntity(name, classBytes, false);
        }
        return classBytes;
    }

    public static byte[] patchRenderLivingBase(String name, byte[] bytes, boolean obf) {
        String targetMethodName = LucraftCoreCoreMod.runtimeObfuscationEnabled ? "prepareScale" : "func_188322_c";
        String targetScaleMethodname = LucraftCoreCoreMod.runtimeObfuscationEnabled ? "scale" : "func_179152_a";
        String targetIsnName = "(Lnet/minecraft/entity/EntityLivingBase;F)F";
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        block0: for (int i = 0; i < classNode.methods.size(); ++i) {
            MethodNode method = (MethodNode)classNode.methods.get(i);
            if (!targetMethodName.equals(method.name) || !targetIsnName.equals(method.desc)) continue;
            InsnList insnList = method.instructions;
            for (int j = 0; j < insnList.size(); ++j) {
                AbstractInsnNode insnNote = method.instructions.get(j);
                if (insnNote.getOpcode() != 184) continue;
                MethodInsnNode method_0 = (MethodInsnNode)insnNote;
                if (!targetScaleMethodname.contains(method_0.name)) continue;
                InsnList insnList_0 = new InsnList();
                insnList_0.add((AbstractInsnNode)new VarInsnNode(25, 0));
                insnList_0.add((AbstractInsnNode)new VarInsnNode(25, 1));
                String parameter = "(Lnet/minecraft/client/renderer/entity/RenderLivingBase;Lnet/minecraft/entity/EntityLivingBase;)V";
                MethodInsnNode method_1 = new MethodInsnNode(184, "lucraft/mods/lucraftcore/core/LCClientHooks", "preRenderCallBack", parameter, false);
                insnList_0.add((AbstractInsnNode)method_1);
                insnList.insert((AbstractInsnNode)method_0, insnList_0);
                break block0;
            }
            break;
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static byte[] patchModelBiped(String name, byte[] bytes, boolean obf) {
        String renderMethod = LucraftCoreCoreMod.runtimeObfuscationEnabled ? "setRotationAngles" : "func_78087_a";
        String renderDesc = "(FFFFFFLnet/minecraft/entity/Entity;)V";
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (int j = 0; j < classNode.methods.size(); ++j) {
            MethodNode method = (MethodNode)classNode.methods.get(j);
            if (!renderMethod.equals(method.name) || !renderDesc.equals(method.desc)) continue;
            for (AbstractInsnNode anode : method.instructions) {
                if (anode.getOpcode() != 177) continue;
                InsnList newInstructions = new InsnList();
                newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newInstructions.add((AbstractInsnNode)new VarInsnNode(23, 1));
                newInstructions.add((AbstractInsnNode)new VarInsnNode(23, 2));
                newInstructions.add((AbstractInsnNode)new VarInsnNode(23, 3));
                newInstructions.add((AbstractInsnNode)new VarInsnNode(23, 4));
                newInstructions.add((AbstractInsnNode)new VarInsnNode(23, 5));
                newInstructions.add((AbstractInsnNode)new VarInsnNode(23, 6));
                newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 7));
                newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, "lucraft/mods/lucraftcore/core/LCClientHooks", "renderBiped", "(Lnet/minecraft/client/model/ModelBiped;FFFFFFLnet/minecraft/entity/Entity;)V", false));
                method.instructions.insertBefore(anode, newInstructions);
            }
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static byte[] patchMinecraft(String name, byte[] classBytes, boolean b) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(classBytes);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode refreshResources = null;
        MethodNode startGame = null;
        for (MethodNode mn : classNode.methods) {
            if (mn.name.equals("func_110436_a") || mn.name.equals("refreshResources")) {
                refreshResources = mn;
                continue;
            }
            if (!mn.name.equals("func_71384_a") && !mn.name.equals("init")) continue;
            startGame = mn;
        }
        if (refreshResources != null) {
            for (int i = 0; i < refreshResources.instructions.size(); ++i) {
                AbstractInsnNode ain = refreshResources.instructions.get(i);
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!min.name.equals("newArrayList")) continue;
                AbstractInsnNode target = refreshResources.instructions.get(i + 1);
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 1));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lucraft/mods/lucraftcore/core/LCClientHooks", "insertAddonPackResourcePacks", "(Ljava/util/List;)V", false));
                refreshResources.instructions.insert(target, toInsert);
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static byte[] patchEntity(String name, byte[] bytes, boolean obf) {
        String setSizeMethod = LucraftCoreCoreMod.runtimeObfuscationEnabled ? "setSize" : "func_70105_a";
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals(setSizeMethod) || !method.desc.equals("(FF)V")) continue;
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new VarInsnNode(23, 1));
            list.add((AbstractInsnNode)new VarInsnNode(23, 2));
            list.add((AbstractInsnNode)new MethodInsnNode(184, "lucraft/mods/lucraftcore/core/LCHooks", "setSize", "(Lnet/minecraft/entity/Entity;FF)V", false));
            for (int i = 0; i < method.instructions.size(); ++i) {
                AbstractInsnNode node = method.instructions.get(i);
                list.add(node);
            }
            method.instructions.clear();
            method.instructions.add(list);
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

