/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.extendedinventory.network;

import io.netty.buffer.ByteBuf;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.extendedinventory.IItemExtendedInventory;
import lucraft.mods.lucraftcore.extendedinventory.InventoryExtendedInventory;
import lucraft.mods.lucraftcore.extendedinventory.capabilities.CapabilityExtendedInventory;
import lucraft.mods.lucraftcore.extendedinventory.capabilities.IExtendedInventoryCapability;
import lucraft.mods.lucraftcore.extendedinventory.events.ExtendedInventoryKeyEvent;
import lucraft.mods.lucraftcore.network.AbstractServerMessageHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageExtendedInventoryKey
implements IMessage {
    public boolean pressed;
    public IItemExtendedInventory.ExtendedInventoryItemType type;

    public MessageExtendedInventoryKey() {
    }

    public MessageExtendedInventoryKey(boolean pressed, IItemExtendedInventory.ExtendedInventoryItemType type) {
        this.pressed = pressed;
        this.type = type;
    }

    public void fromBytes(ByteBuf buf) {
        this.pressed = buf.readBoolean();
        this.type = IItemExtendedInventory.ExtendedInventoryItemType.values()[buf.readInt()];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.pressed);
        buf.writeInt(this.type.ordinal());
    }

    public static class Handler
    extends AbstractServerMessageHandler<MessageExtendedInventoryKey> {
        @Override
        public IMessage handleServerMessage(final EntityPlayer player, final MessageExtendedInventoryKey message, final MessageContext ctx) {
            LucraftCore.proxy.getThreadFromContext(ctx).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    if (message != null && ctx != null) {
                        if (MinecraftForge.EVENT_BUS.post((Event)new ExtendedInventoryKeyEvent.Server(message.type, player, message.pressed))) {
                            return;
                        }
                        InventoryExtendedInventory inv = ((IExtendedInventoryCapability)player.getCapability(CapabilityExtendedInventory.EXTENDED_INVENTORY_CAP, null)).getInventory();
                        ItemStack s = null;
                        switch (message.type) {
                            case NECKLACE: {
                                s = inv.func_70301_a(0);
                                break;
                            }
                            case MANTLE: {
                                s = inv.func_70301_a(1);
                                break;
                            }
                            case WRIST: {
                                s = inv.func_70301_a(2);
                                break;
                            }
                        }
                        if (s != null && !s.func_190926_b() && s.func_77973_b() instanceof IItemExtendedInventory && ((IItemExtendedInventory)s.func_77973_b()).useButton(s, player)) {
                            ((IItemExtendedInventory)s.func_77973_b()).onPressedButton(s, player, message.pressed);
                        }
                    }
                }
            });
            return null;
        }
    }
}

