/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.karma.capabilities;

import java.util.HashMap;
import java.util.Map;
import lucraft.mods.lucraftcore.karma.KarmaHandler;
import lucraft.mods.lucraftcore.karma.KarmaStat;
import lucraft.mods.lucraftcore.karma.capabilities.CapabilityKarmaProvider;
import lucraft.mods.lucraftcore.karma.capabilities.IKarmaCapability;
import lucraft.mods.lucraftcore.karma.network.MessageSyncKarma;
import lucraft.mods.lucraftcore.network.LCPacketDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CapabilityKarma
implements IKarmaCapability {
    @CapabilityInject(value=IKarmaCapability.class)
    public static final Capability<IKarmaCapability> KARMA_CAP = null;
    public EntityPlayer player;
    public int karma;
    public Map<KarmaStat, Integer> karmaStats = new HashMap<KarmaStat, Integer>();
    public boolean knockOutMode;

    public CapabilityKarma(EntityPlayer player) {
        this.player = player;
    }

    @Override
    public NBTTagCompound writeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagCompound statsTag = new NBTTagCompound();
        for (KarmaStat stat : this.karmaStats.keySet()) {
            NBTTagCompound karmaTag = new NBTTagCompound();
            karmaTag.func_74768_a("Amount", this.karmaStats.get((Object)stat).intValue());
            statsTag.func_74782_a(stat.getRegistryName().toString(), (NBTBase)karmaTag);
        }
        nbt.func_74782_a("Stats", (NBTBase)statsTag);
        nbt.func_74768_a("Karma", this.karma);
        return nbt;
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        NBTTagCompound statsTag = nbt.func_74775_l("Stats");
        for (KarmaStat stat : KarmaStat.KARMA_STAT_REGISTRY.getValues()) {
            this.karmaStats.put(stat, statsTag.func_74775_l(stat.getRegistryName().toString()).func_74762_e("Amount"));
        }
        this.karma = nbt.func_74762_e("Karma");
    }

    @Override
    public int getKarma() {
        return this.karma;
    }

    @Override
    public void setKarmaStat(KarmaStat stat, int amount) {
        this.karmaStats.put(stat, amount);
        this.updateKarmaValue();
        this.syncToPlayer();
    }

    @Override
    public int getKarmaStat(KarmaStat stat) {
        return this.karmaStats.containsKey((Object)stat) ? this.karmaStats.get((Object)stat) : 0;
    }

    public void updateKarmaValue() {
        int i = 0;
        for (KarmaStat stat : this.karmaStats.keySet()) {
            i += stat.getAmount() * KarmaHandler.getKarmaStat(this.player, stat);
        }
        this.karma = i;
    }

    @Override
    public void syncToPlayer() {
        this.syncToPlayer(this.player);
    }

    @Override
    public void syncToPlayer(EntityPlayer receiver) {
        if (receiver instanceof EntityPlayerMP) {
            LCPacketDispatcher.sendTo(new MessageSyncKarma(this.player), (EntityPlayerMP)receiver);
        }
    }

    @Override
    public void syncToAll() {
        this.syncToPlayer();
        if (this.player.field_70170_p instanceof WorldServer) {
            for (EntityPlayer players : ((WorldServer)this.player.field_70170_p).func_73039_n().getTrackingPlayers((Entity)this.player)) {
                if (!(players instanceof EntityPlayerMP)) continue;
                LCPacketDispatcher.sendTo(new MessageSyncKarma(this.player), (EntityPlayerMP)players);
            }
        }
    }

    public static class Storage
    implements Capability.IStorage<IKarmaCapability> {
        public NBTBase writeNBT(Capability<IKarmaCapability> capability, IKarmaCapability instance, EnumFacing side) {
            return instance.writeNBT();
        }

        public void readNBT(Capability<IKarmaCapability> capability, IKarmaCapability instance, EnumFacing side, NBTBase nbt) {
            instance.readNBT((NBTTagCompound)nbt);
        }
    }

    public static class EventHandler {
        @SubscribeEvent
        public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
            if (!(evt.getObject() instanceof EntityPlayer) || ((Entity)evt.getObject()).hasCapability(KARMA_CAP, null)) {
                return;
            }
            evt.addCapability(new ResourceLocation("lucraftcore", "karma"), (ICapabilityProvider)new CapabilityKarmaProvider(new CapabilityKarma((EntityPlayer)evt.getObject())));
        }

        @SubscribeEvent
        public void onPlayerStartTracking(PlayerEvent.StartTracking e) {
            if (e.getTarget().hasCapability(KARMA_CAP, null)) {
                ((IKarmaCapability)e.getTarget().getCapability(KARMA_CAP, null)).syncToPlayer(e.getEntityPlayer());
            }
        }

        @SubscribeEvent
        public void onPlayerClone(PlayerEvent.Clone e) {
            NBTTagCompound compound = new NBTTagCompound();
            compound = (NBTTagCompound)KARMA_CAP.getStorage().writeNBT(KARMA_CAP, e.getOriginal().getCapability(KARMA_CAP, null), null);
            KARMA_CAP.getStorage().readNBT(KARMA_CAP, e.getEntityPlayer().getCapability(KARMA_CAP, null), null, (NBTBase)compound);
        }
    }
}

