/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.karma.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.naming.NoPermissionException;
import lucraft.mods.lucraftcore.karma.KarmaHandler;
import lucraft.mods.lucraftcore.karma.KarmaStat;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;

public class CommandKarma
extends CommandBase {
    public String func_71517_b() {
        return "karma";
    }

    public int func_82362_a() {
        return 0;
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.karma.usage";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 3 && args[0].equalsIgnoreCase("set")) {
            if (sender.func_70003_b(2, this.func_71517_b())) {
                EntityPlayerMP player = CommandKarma.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
                int amount = CommandKarma.func_175755_a((String)args[2]);
                KarmaHandler.setKarmaStat((EntityPlayer)player, KarmaStat.MODIFIED, amount);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.karma.karmaset", new Object[]{player.func_70005_c_(), amount}));
                CommandKarma.func_152374_a((ICommandSender)sender, (ICommand)this, (int)1, (String)"commands.karma.karmaset", (Object[])new Object[]{player.func_70005_c_(), amount});
                return;
            }
            try {
                throw new NoPermissionException();
            }
            catch (NoPermissionException e) {
                e.printStackTrace();
                return;
            }
        }
        if (args.length == 0) {
            this.sendKarmaInfoMessage(sender, (EntityPlayer)CommandKarma.func_71521_c((ICommandSender)sender));
            return;
        } else {
            if (args.length != 1) throw new WrongUsageException("commands.karma.usage", new Object[0]);
            EntityPlayerMP player = CommandKarma.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
            this.sendKarmaInfoMessage(sender, (EntityPlayer)player);
        }
    }

    public void sendKarmaInfoMessage(ICommandSender sender, EntityPlayer player) {
        Object text = new TextComponentTranslation("commands.karma.playersstats", new Object[]{TextFormatting.BOLD + "" + TextFormatting.UNDERLINE + player.func_70005_c_()});
        Style style = new Style();
        style.func_150227_a(Boolean.valueOf(true));
        style.func_150228_d(Boolean.valueOf(true));
        text.func_150255_a(style);
        sender.func_145747_a((ITextComponent)text);
        for (KarmaStat stat : KarmaStat.getKarmaStats()) {
            TextComponentString text2 = new TextComponentString("   ");
            text2.func_150257_a((ITextComponent)new TextComponentTranslation(stat.getUnlocalizedName(), new Object[0]));
            int statAmount = KarmaHandler.getKarmaStat(player, stat);
            text2.func_150258_a(": " + statAmount);
            text2.func_150258_a(" " + TextFormatting.GRAY + TextFormatting.ITALIC + "(* " + stat.getAmount() + " = " + stat.getAmount() * statAmount + ")");
            Style style2 = new Style();
            style2.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation(stat.getUnlocalizedDescription(), new Object[0])));
            text2.func_150255_a(style2);
            sender.func_145747_a((ITextComponent)text2);
        }
        text = new TextComponentString("   ");
        text.func_150257_a((ITextComponent)new TextComponentTranslation("commands.karma.karma", new Object[0]));
        text.func_150258_a("" + KarmaHandler.getKarma(player));
        sender.func_145747_a((ITextComponent)text);
        text = new TextComponentString("   ");
        text.func_150257_a((ITextComponent)new TextComponentTranslation("commands.karma.class", new Object[0]));
        text.func_150257_a((ITextComponent)new TextComponentTranslation(KarmaHandler.getKarmaClass(player).getUnlocalizedName(), new Object[0]));
        style = new Style();
        TextComponentString hover = new TextComponentString("");
        for (int i = 0; i < KarmaStat.KarmaClass.values().length; ++i) {
            KarmaStat.KarmaClass kc = KarmaStat.KarmaClass.values()[i];
            TextComponentTranslation t = new TextComponentTranslation(kc.getUnlocalizedName(), new Object[0]);
            if (KarmaHandler.getKarmaClass(player) == kc) {
                Style s = new Style();
                s.func_150227_a(Boolean.valueOf(true));
                t.func_150255_a(s);
            }
            hover.func_150257_a((ITextComponent)t);
            if (i >= KarmaStat.KarmaClass.values().length - 1) continue;
            hover.func_150258_a("\n");
        }
        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)hover));
        text.func_150255_a(style);
        sender.func_145747_a((ITextComponent)text);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 1) {
            ArrayList<String> args1 = new ArrayList<String>();
            args1.add("set");
            for (String s : CommandKarma.func_71530_a((String[])args, (String[])server.func_71213_z())) {
                args1.add(s);
            }
            return args1;
        }
        return args.length == 2 ? CommandKarma.func_71530_a((String[])args, (String[])server.func_71213_z()) : Collections.emptyList();
    }
}

