/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers;

import java.util.List;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.IAbilityProvider;
import lucraft.mods.lucraftcore.superpowers.effects.Effect;
import lucraft.mods.lucraftcore.superpowers.gui.GuiAbilities;
import lucraft.mods.lucraftcore.superpowers.render.SuperpowerRenderer;
import lucraft.mods.lucraftcore.util.helper.StringHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class Superpower
extends IForgeRegistryEntry.Impl<Superpower>
implements IAbilityProvider {
    private String name;

    public Superpower(String name) {
        this.name = name;
    }

    public String getUnlocalizedName() {
        return this.name;
    }

    public String getDisplayName() {
        return StringHelper.translateToLocal("superpower." + this.name + ".name");
    }

    @SideOnly(value=Side.CLIENT)
    public final void renderIcon(Minecraft mc, int x, int y) {
        this.renderIcon(mc, (Gui)Minecraft.func_71410_x().field_71462_r, x, y);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderIcon(Minecraft mc, Gui gui, int x, int y) {
    }

    public boolean canLevelUp() {
        return false;
    }

    public int getMaxLevel() {
        return 0;
    }

    public int getXPForLevel(int level) {
        switch (level) {
            case 1: {
                return 0;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return (level - 1) * 1000;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return 10000;
            }
            case 15: {
                return 15000;
            }
            case 16: 
            case 17: 
            case 18: {
                return 20000;
            }
            case 19: 
            case 20: {
                return 25000;
            }
            case 21: {
                return 50000;
            }
            case 22: {
                return 75000;
            }
            case 23: {
                return 100000;
            }
            case 24: {
                return 125000;
            }
            case 25: {
                return 150000;
            }
            case 26: {
                return 190000;
            }
            case 27: {
                return 20000;
            }
            case 28: {
                return 250000;
            }
            case 29: {
                return 300000;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                return 350000;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                return 375000;
            }
        }
        return 0;
    }

    public String getXPTranslationName() {
        return "lucraftcore.info.xp";
    }

    public String getXPName() {
        return StringHelper.translateToLocal(this.getXPTranslationName());
    }

    @SideOnly(value=Side.CLIENT)
    public SuperpowerRenderer.ISuperpowerRenderer getPlayerRenderer() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getAbilityGui(EntityPlayer player) {
        return new GuiAbilities(player, Ability.EnumAbilityContext.SUPERPOWER);
    }

    @SideOnly(value=Side.CLIENT)
    public int getCapsuleColor() {
        return 15073794;
    }

    public List<Effect> getEffects() {
        return null;
    }

    public NBTTagCompound getData() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldAddToTab(EntityPlayer player) {
        return true;
    }
}

