/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.abilities;

import java.awt.Color;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityAction;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityData;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataColor;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataFloat;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataNBTTagCompound;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.EnumSync;
import lucraft.mods.lucraftcore.superpowers.entities.EntityEnergyBlast;
import lucraft.mods.lucraftcore.util.helper.LCRenderHelper;
import lucraft.mods.lucraftcore.util.helper.PlayerHelper;
import lucraft.mods.lucraftcore.util.sounds.LCSoundEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AbilityEnergyBlast
extends AbilityAction {
    public static final AbilityData<Float> DAMAGE = new AbilityDataFloat("damage").disableSaving().setSyncType(EnumSync.SELF).enableSetting("damage", "The amount of damage that the energy blast entity will cause");
    public static final AbilityData<Color> COLOR = new AbilityDataColor("color").disableSaving().enableSetting("color", "Sets the color for the energy blast");
    public static final AbilityData<NBTTagCompound> ENTITY_DATA = new AbilityDataNBTTagCompound("entity_data").setSyncType(EnumSync.NONE).enableSetting("entity_data", "NBT tag for the entity that will be spawned");

    public AbilityEnergyBlast(EntityLivingBase entity) {
        super(entity);
    }

    @Override
    public void registerData() {
        super.registerData();
        this.dataManager.register(DAMAGE, Float.valueOf(3.0f));
        this.dataManager.register(COLOR, Color.RED);
        this.dataManager.register(ENTITY_DATA, new NBTTagCompound());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawIcon(Minecraft mc, Gui gui, int x, int y) {
        Color color = this.dataManager.get(COLOR);
        GlStateManager.func_179124_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
        LCRenderHelper.drawIcon(mc, gui, x, y, 0, 15);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        LCRenderHelper.drawIcon(mc, gui, x, y, 0, 14);
    }

    @Override
    public boolean action() {
        if (!this.entity.field_70170_p.field_72995_K) {
            EntityEnergyBlast entity = new EntityEnergyBlast(this.entity.field_70170_p, this.entity, this.dataManager.get(DAMAGE).floatValue(), this.dataManager.get(COLOR));
            if (!this.dataManager.get(ENTITY_DATA).func_82582_d()) {
                NBTTagCompound compound = this.dataManager.get(ENTITY_DATA);
                entity.func_70020_e(compound);
                if (compound.func_150297_b("Passengers", 9)) {
                    NBTTagList nbttaglist = compound.func_150295_c("Passengers", 10);
                    for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                        Entity entity1 = AnvilChunkLoader.func_186054_a((NBTTagCompound)nbttaglist.func_150305_b(i), (World)this.entity.field_70170_p, (double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v, (boolean)true);
                        if (entity1 == null) continue;
                        entity1.func_184205_a((Entity)entity, true);
                    }
                }
            }
            entity.func_70107_b(this.entity.field_70165_t, this.entity.field_70163_u + (double)this.entity.func_70047_e() - (double)0.1f, this.entity.field_70161_v);
            entity.color = this.dataManager.get(COLOR);
            entity.func_184538_a((Entity)this.entity, this.entity.field_70125_A, this.entity.field_70177_z, 0.0f, 1.5f, 1.0f);
            this.entity.field_70170_p.func_72838_d((Entity)entity);
            PlayerHelper.playSoundToAll(this.entity.field_70170_p, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, 50.0, LCSoundEvents.ENERGY_BLAST, SoundCategory.PLAYERS);
        }
        return true;
    }
}

