/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.items;

import lucraft.mods.lucraftcore.superpowers.Superpower;
import lucraft.mods.lucraftcore.superpowers.SuperpowerHandler;
import lucraft.mods.lucraftcore.utilities.items.ItemInjection;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class SuperpowerItems {
    public void loadSuperpowerInjection() {
        for (Superpower power : SuperpowerHandler.SUPERPOWER_REGISTRY.getValues()) {
            InjectionSuperpower in = new InjectionSuperpower(power);
            ItemInjection.registerInjection(in, power.getRegistryName());
        }
    }

    public static class InjectionSuperpower
    extends ItemInjection.Injection {
        public Superpower superpower;

        public InjectionSuperpower(Superpower superpower) {
            super(superpower.getUnlocalizedName());
            this.superpower = superpower;
        }

        @Override
        public String getDisplayName() {
            return this.superpower.getDisplayName();
        }

        @Override
        public int chanceForInjection(EntityPlayer player, ItemStack stack) {
            return 100;
        }

        @Override
        public ItemStack inject(EntityPlayer player, ItemStack stack) {
            SuperpowerHandler.giveSuperpower((EntityLivingBase)player, this.superpower);
            return stack;
        }

        @Override
        public int priorityForRemoving(EntityPlayer player, ItemStack stack) {
            if (SuperpowerHandler.getSuperpower((EntityLivingBase)player) == this.superpower) {
                return 100;
            }
            return 0;
        }

        @Override
        public ItemStack removeFromPlayer(EntityPlayer player, ItemStack stack) {
            SuperpowerHandler.removeSuperpower((EntityLivingBase)player);
            return stack;
        }

        @Override
        public int getColor() {
            return this.superpower.getCapsuleColor();
        }
    }
}

