/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.network.AbstractClientMessageHandler;
import lucraft.mods.lucraftcore.superpowers.capabilities.CapabilitySuperpower;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSyncSuperpower
implements IMessage {
    public UUID entityUUID;
    public NBTTagCompound nbt;

    public MessageSyncSuperpower() {
    }

    public MessageSyncSuperpower(EntityLivingBase entity) {
        this.entityUUID = entity.getPersistentID();
        this.nbt = (NBTTagCompound)CapabilitySuperpower.SUPERPOWER_CAP.getStorage().writeNBT(CapabilitySuperpower.SUPERPOWER_CAP, entity.getCapability(CapabilitySuperpower.SUPERPOWER_CAP, null), null);
    }

    public void fromBytes(ByteBuf buf) {
        this.entityUUID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.nbt = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.entityUUID.toString());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbt);
    }

    public static class Handler
    extends AbstractClientMessageHandler<MessageSyncSuperpower> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, MessageSyncSuperpower message, MessageContext ctx) {
            LucraftCore.proxy.getThreadFromContext(ctx).func_152344_a(() -> {
                if (message != null && ctx != null) {
                    EntityLivingBase en = null;
                    for (Entity entity : LucraftCore.proxy.getPlayerEntity((MessageContext)ctx).field_70170_p.func_72910_y()) {
                        if (!(entity instanceof EntityLivingBase) || !entity.getPersistentID().equals(message.entityUUID)) continue;
                        en = (EntityLivingBase)entity;
                    }
                    if (en != null) {
                        CapabilitySuperpower.SUPERPOWER_CAP.getStorage().readNBT(CapabilitySuperpower.SUPERPOWER_CAP, en.getCapability(CapabilitySuperpower.SUPERPOWER_CAP, null), null, (NBTBase)message.nbt);
                    }
                }
            });
            return null;
        }
    }
}

