/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.render;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import lucraft.mods.lucraftcore.superpowers.Superpower;
import lucraft.mods.lucraftcore.superpowers.SuperpowerHandler;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.AbilityContainer;
import lucraft.mods.lucraftcore.superpowers.capabilities.ISuperpowerCapability;
import lucraft.mods.lucraftcore.superpowers.effects.EffectHUD;
import lucraft.mods.lucraftcore.superpowers.effects.EffectHandler;
import lucraft.mods.lucraftcore.superpowers.effects.EffectSkinChange;
import lucraft.mods.lucraftcore.superpowers.effects.EffectTrail;
import lucraft.mods.lucraftcore.util.events.RenderModelEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SuperpowerRenderer {
    public static Minecraft mc = Minecraft.func_71410_x();
    public static boolean overrideSkin = true;

    @SubscribeEvent(receiveCanceled=true)
    public void onSetRotationAngels(RenderModelEvent.SetRotationAngels e) {
        if (overrideSkin && e.getEntity() instanceof EntityPlayer && e.model instanceof ModelPlayer) {
            EntityPlayer player = (EntityPlayer)e.getEntity();
            for (EffectSkinChange skinChange : EffectHandler.getEffectsByClass(player, EffectSkinChange.class)) {
                if (!EffectHandler.canEffectBeDisplayed(skinChange, player)) continue;
                SuperpowerRenderer.mc.field_71446_o.func_110577_a(skinChange.texture);
            }
        }
    }

    @SubscribeEvent
    public void onChat(ServerChatEvent e) {
        e.getPlayer().refreshDisplayName();
    }

    @SubscribeEvent
    public void onRenderSpecificHand(RenderSpecificHandEvent e) {
        Superpower superpower = SuperpowerHandler.getSuperpower((EntityLivingBase)SuperpowerRenderer.mc.field_71439_g);
        if (superpower != null && superpower.getPlayerRenderer() != null) {
            superpower.getPlayerRenderer().onRenderSpecificHandEvent(e);
        }
    }

    @SubscribeEvent
    public void onRenderHand(RenderHandEvent e) {
        Superpower superpower = SuperpowerHandler.getSuperpower((EntityLivingBase)SuperpowerRenderer.mc.field_71439_g);
        if (superpower != null && superpower.getPlayerRenderer() != null) {
            superpower.getPlayerRenderer().onRenderHandEvent(e);
        }
    }

    @SubscribeEvent
    public void onRenderHUD(RenderGameOverlayEvent e) {
        Superpower superpower = SuperpowerHandler.getSuperpower((EntityLivingBase)SuperpowerRenderer.mc.field_71439_g);
        if (superpower != null && superpower.getPlayerRenderer() != null) {
            superpower.getPlayerRenderer().onRenderGameOverlay(e);
        }
    }

    @SubscribeEvent
    public void onRenderPlayerPost(RenderPlayerEvent.Post e) {
        ArrayList<EffectTrail> trailEffects = new ArrayList<EffectTrail>();
        for (EffectTrail.EntityTrail entityTrail : SuperpowerHandler.getSuperpowerCapability((EntityLivingBase)e.getEntityPlayer()).getTrailEntities()) {
            for (EffectTrail effects : entityTrail.effects) {
                if (trailEffects.contains(effects)) continue;
                trailEffects.add(effects);
            }
        }
        for (EffectTrail effectTrail : trailEffects) {
            effectTrail.type.getTrailRenderer().renderTrail(e.getEntityPlayer(), effectTrail, SuperpowerHandler.getSuperpowerCapability((EntityLivingBase)e.getEntityPlayer()).getTrailEntities(), e.getPartialRenderTick());
        }
    }

    @SubscribeEvent
    public void onRenderHUD(RenderGameOverlayEvent.Post e) {
        if (e.getType() == RenderGameOverlayEvent.ElementType.HELMET) {
            if (SuperpowerRenderer.mc.field_71474_y.field_74320_O == 0) {
                List<EffectHUD> effects = EffectHandler.getEffectsByClass((EntityPlayer)Minecraft.func_71410_x().field_71439_g, EffectHUD.class);
                if (effects.size() <= 0) {
                    return;
                }
                GlStateManager.func_179097_i();
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179118_c();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                ScaledResolution scaledRes = e.getResolution();
                for (EffectHUD hud : effects) {
                    if (!EffectHandler.canEffectBeDisplayed(hud, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) continue;
                    mc.func_110434_K().func_110577_a(hud.texture);
                    bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    bufferbuilder.func_181662_b(0.0, (double)scaledRes.func_78328_b(), -90.0).func_187315_a(0.0, 1.0).func_181675_d();
                    bufferbuilder.func_181662_b((double)scaledRes.func_78326_a(), (double)scaledRes.func_78328_b(), -90.0).func_187315_a(1.0, 1.0).func_181675_d();
                    bufferbuilder.func_181662_b((double)scaledRes.func_78326_a(), 0.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
                    bufferbuilder.func_181662_b(0.0, 0.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
                    tessellator.func_78381_a();
                }
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179126_j();
                GlStateManager.func_179141_d();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent e) {
        if (e.getEntityLiving() instanceof EntityPlayer) {
            ArrayList<EffectTrail> trailEffects = new ArrayList<EffectTrail>();
            for (EffectTrail trails : EffectHandler.getEffectsByClass((EntityPlayer)e.getEntityLiving(), EffectTrail.class)) {
                if (!EffectHandler.canEffectBeDisplayed(trails, (EntityPlayer)e.getEntityLiving())) continue;
                trailEffects.add(trails);
            }
            if (trailEffects.size() > 0) {
                ISuperpowerCapability cap = SuperpowerHandler.getSuperpowerCapability((EntityLivingBase)((EntityPlayer)e.getEntityLiving()));
                LinkedList<EffectTrail.EntityTrail> list = cap.getTrailEntities();
                if (list.size() == 0) {
                    EffectTrail.EntityTrail trail = new EffectTrail.EntityTrail(e.getEntityLiving().func_130014_f_(), (EntityPlayer)e.getEntityLiving(), trailEffects.toArray(new EffectTrail[trailEffects.size()]));
                    cap.addTrailEntity((Entity)trail);
                    e.getEntityLiving().func_130014_f_().func_72838_d((Entity)trail);
                } else if (e.getEntityLiving().func_70032_d((Entity)list.getLast()) >= e.getEntityLiving().field_70130_N * 1.1f) {
                    EffectTrail.EntityTrail trail = new EffectTrail.EntityTrail(e.getEntityLiving().func_130014_f_(), (EntityPlayer)e.getEntityLiving(), trailEffects.toArray(new EffectTrail[trailEffects.size()]));
                    cap.addTrailEntity((Entity)trail);
                    e.getEntityLiving().func_130014_f_().func_72838_d((Entity)trail);
                }
            }
        }
    }

    public static interface ISuperpowerRenderer {
        @SideOnly(value=Side.CLIENT)
        public void onRenderPlayer(RenderLivingBase<?> var1, Minecraft var2, EntityPlayer var3, Superpower var4, AbilityContainer var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12);

        default public void applyColor() {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }

        default public void onRenderHandEvent(RenderHandEvent e) {
        }

        default public void onRenderSpecificHandEvent(RenderSpecificHandEvent e) {
        }

        default public void onRenderGameOverlay(RenderGameOverlayEvent e) {
        }
    }
}

