/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.util.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandLocate;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;

public class CommandLocateExt
extends CommandLocate {
    public static Map<String, ILocateCommandEntry> ENTRIES = new HashMap<String, ILocateCommandEntry>();

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 1) {
            throw new WrongUsageException("commands.locate.usage", new Object[0]);
        }
        String s = args[0];
        BlockPos blockpos = CommandLocateExt.getPosFromStructure(s, sender.func_130014_f_(), sender.func_180425_c());
        if (blockpos == null) {
            throw new CommandException("commands.locate.failure", new Object[]{s});
        }
        TextComponentTranslation textComponent = new TextComponentTranslation("commands.locate.success", new Object[]{s, blockpos.func_177958_n(), blockpos.func_177952_p()});
        Style style = new Style();
        ClickEvent event = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @p " + blockpos.func_177958_n() + " ~ " + blockpos.func_177952_p());
        style.func_150241_a(event);
        textComponent.func_150255_a(style);
        sender.func_145747_a((ITextComponent)textComponent);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList("Stronghold", "Monument", "Village", "Mansion", "EndCity", "Fortress", "Temple", "Mineshaft"));
        for (String s : ENTRIES.keySet()) {
            list.add(s);
        }
        return args.length == 1 ? CommandLocateExt.func_175762_a((String[])args, list) : Collections.emptyList();
    }

    public static BlockPos getPosFromStructure(String structure, World world, BlockPos pos) {
        if (ENTRIES.containsKey(structure)) {
            return ENTRIES.get(structure).getPosition(world, pos);
        }
        return world.func_190528_a(structure, pos, false);
    }

    public static interface ILocateCommandEntry {
        public BlockPos getPosition(World var1, BlockPos var2);
    }
}

