/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.util.helper;

import java.util.Iterator;
import lucraft.mods.lucraftcore.network.LCPacketDispatcher;
import lucraft.mods.lucraftcore.util.helper.CustomTeleporter;
import lucraft.mods.lucraftcore.util.network.MessageSpawnParticle;
import lucraft.mods.lucraftcore.util.network.MessageSwingArm;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketCustomSound;
import net.minecraft.network.play.server.SPacketParticles;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerHelper {
    public static void playSound(World world, EntityPlayer player, double x, double y, double z, SoundEvent sound, SoundCategory category) {
        PlayerHelper.playSound(world, player, x, y, z, sound, category, 1.0f, 1.0f);
    }

    public static void playSound(World world, EntityPlayer player, double x, double y, double z, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketCustomSound(sound.getRegistryName().toString(), category, x, y, z, volume, pitch));
        }
    }

    public static void playSoundToAll(World world, double x, double y, double z, double range, SoundEvent sound, SoundCategory category) {
        PlayerHelper.playSoundToAll(world, x, y, z, range, sound, category, 1.0f, 1.0f);
    }

    public static void playSoundToAll(World world, double x, double y, double z, double range, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        AxisAlignedBB a = new AxisAlignedBB(new BlockPos(x - range, y - range, z - range), new BlockPos(x + range, y + range, z + range));
        for (EntityPlayer players : world.func_72872_a(EntityPlayer.class, a)) {
            if (!(players instanceof EntityPlayerMP)) continue;
            ((EntityPlayerMP)players).field_71135_a.func_147359_a((Packet)new SPacketCustomSound(sound.getRegistryName().toString(), category, x, y, z, volume, pitch));
        }
    }

    public static void spawnParticle(EntityPlayer player, int particleId, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        if (player instanceof EntityPlayerMP) {
            LCPacketDispatcher.sendTo(new MessageSpawnParticle(particleId, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, parameters), (EntityPlayerMP)player);
        }
    }

    public static void spawnParticleForAll(World world, double range, int particleId, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        AxisAlignedBB a = new AxisAlignedBB(new BlockPos(xCoord - range, yCoord - range, zCoord - range), new BlockPos(xCoord + range, yCoord + range, zCoord + range));
        for (EntityPlayer players : world.func_72872_a(EntityPlayer.class, a)) {
            PlayerHelper.spawnParticle(players, particleId, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, parameters);
        }
    }

    public static void spawnParticle(EntityPlayer player, EnumParticleTypes particleIn, boolean longDistanceIn, float xIn, float yIn, float zIn, float xOffsetIn, float yOffsetIn, float zOffsetIn, float speedIn, int countIn, int ... argumentsIn) {
        if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketParticles(particleIn, longDistanceIn, xIn, yIn, zIn, xOffsetIn, yOffsetIn, zOffsetIn, speedIn, countIn, argumentsIn));
        }
    }

    public static void spawnParticleForAll(World world, double range, EnumParticleTypes particleIn, boolean longDistanceIn, float xIn, float yIn, float zIn, float xOffsetIn, float yOffsetIn, float zOffsetIn, float speedIn, int countIn, int ... argumentsIn) {
        AxisAlignedBB a = new AxisAlignedBB(new BlockPos((double)xIn - range, (double)yIn - range, (double)zIn - range), new BlockPos((double)xIn + range, (double)yIn + range, (double)zIn + range));
        for (EntityPlayer players : world.func_72872_a(EntityPlayer.class, a)) {
            PlayerHelper.spawnParticle(players, particleIn, longDistanceIn, xIn, yIn, zIn, xOffsetIn, yOffsetIn, zOffsetIn, speedIn, countIn, argumentsIn);
        }
    }

    public static void givePlayerItemStack(EntityPlayer player, ItemStack stack) {
        if (player.func_184614_ca().func_190926_b()) {
            player.func_184201_a(EntityEquipmentSlot.MAINHAND, stack);
        } else if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, true);
        }
    }

    public static void teleportToDimension(EntityPlayer player, int dimension, double x, double y, double z) {
        int oldDimension = player.field_70170_p.field_73011_w.getDimension();
        EntityPlayerMP entityPlayerMP = (EntityPlayerMP)player;
        MinecraftServer server = ((EntityPlayerMP)player).field_70170_p.func_73046_m();
        WorldServer worldServer = server.func_71218_a(dimension);
        player.func_82242_a(0);
        if (player.field_71093_bK != dimension) {
            worldServer.func_73046_m().func_184103_al().transferPlayerToDimension(entityPlayerMP, dimension, (Teleporter)new CustomTeleporter(worldServer, x, y, z));
        }
        player.func_70634_a(x, y, z);
        if (oldDimension == 1) {
            player.func_70634_a(x, y, z);
            worldServer.func_72838_d((Entity)player);
            worldServer.func_72866_a((Entity)player, false);
        }
    }

    public static void swingPlayerArm(EntityPlayer player, EnumHand hand) {
        LCPacketDispatcher.sendToAll(new MessageSwingArm(player, hand));
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean hasSmallArms(EntityPlayer player) {
        if (player instanceof AbstractClientPlayer) {
            return ((AbstractClientPlayer)player).func_175154_l().equalsIgnoreCase("slim");
        }
        return false;
    }

    public static RayTraceResult rayTrace(EntityPlayer player, double distance) {
        Vec3d lookVec = player.func_70040_Z();
        int i = 0;
        while ((double)i < distance * 2.0) {
            float scale = (float)i / 2.0f;
            Vec3d pos = player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0).func_178787_e(lookVec.func_186678_a((double)scale));
            if (player.field_70170_p.func_175665_u(new BlockPos(pos)) && !player.field_70170_p.func_175623_d(new BlockPos(pos))) {
                return new RayTraceResult(pos, null);
            }
            Vec3d pos1 = pos.func_72441_c(0.25, 0.25, 0.25);
            Vec3d pos2 = pos.func_72441_c(-0.25, -0.25, -0.25);
            Iterator iterator = player.field_70170_p.func_72839_b((Entity)player, new AxisAlignedBB(pos1.field_72450_a, pos1.field_72448_b, pos1.field_72449_c, pos2.field_72450_a, pos2.field_72448_b, pos2.field_72449_c)).iterator();
            if (iterator.hasNext()) {
                Entity entity = (Entity)iterator.next();
                return new RayTraceResult(entity);
            }
            ++i;
        }
        return new RayTraceResult(player.func_174791_d().func_178787_e(lookVec.func_186678_a(distance)), null);
    }
}

