/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.utilities.blocks;

import java.util.Random;
import javax.annotation.Nonnull;
import lucraft.mods.lucraftcore.util.energy.EnergyStorageExt;
import lucraft.mods.lucraftcore.util.fluids.FluidTankExt;
import lucraft.mods.lucraftcore.util.fluids.LCFluidUtil;
import lucraft.mods.lucraftcore.util.helper.PlayerHelper;
import lucraft.mods.lucraftcore.utilities.recipes.ExtractorRecipeHandler;
import lucraft.mods.lucraftcore.utilities.recipes.IExtractorRecipe;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TileEntityExtractor
extends TileEntity
implements ITickable {
    public static final int TANK_CAPACITY = 5000;
    public ItemStackHandler inputSlots = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            TileEntityExtractor.this.detectRecipe();
        }
    };
    public ItemStackHandler outputSlots = new ItemStackHandler(2);
    public ItemStackHandler fluidContainerSlots = new ItemStackHandler(2){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return FluidUtil.getFluidHandler((ItemStack)stack) != null;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            ItemStack stack = this.getStackInSlot(slot);
            if (stack.func_190926_b()) {
                return;
            }
            if (slot == 0) {
                ItemStack result = LCFluidUtil.transferFluidFromItemToTank(stack, TileEntityExtractor.this.fluidTank, TileEntityExtractor.this.fluidContainerSlots);
                if (!result.func_190926_b()) {
                    TileEntityExtractor.this.fluidTank.update = true;
                    this.setStackInSlot(slot, result);
                    PlayerHelper.playSoundToAll(TileEntityExtractor.this.field_145850_b, TileEntityExtractor.this.func_174877_v().func_177958_n(), TileEntityExtractor.this.func_174877_v().func_177956_o(), TileEntityExtractor.this.func_174877_v().func_177952_p(), 50.0, TileEntityExtractor.this.fluidTank.getFluid().getFluid().getEmptySound(TileEntityExtractor.this.fluidTank.getFluid()), SoundCategory.BLOCKS);
                }
            } else {
                ItemStack result = LCFluidUtil.transferFluidFromTankToItem(stack, TileEntityExtractor.this.fluidTank, TileEntityExtractor.this.fluidContainerSlots);
                if (!result.func_190926_b()) {
                    TileEntityExtractor.this.fluidTank.update = true;
                    this.setStackInSlot(slot, result);
                    FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)result);
                    if (fluidStack != null) {
                        PlayerHelper.playSoundToAll(TileEntityExtractor.this.field_145850_b, TileEntityExtractor.this.func_174877_v().func_177958_n(), TileEntityExtractor.this.func_174877_v().func_177956_o(), TileEntityExtractor.this.func_174877_v().func_177952_p(), 50.0, fluidStack.getFluid().getFillSound(fluidStack), SoundCategory.BLOCKS);
                    }
                }
            }
        }
    };
    protected CombinedInvWrapper combinedSlots = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.fluidContainerSlots, this.inputSlots, this.outputSlots});
    public FluidTankExt fluidTank = new FluidTankExt(5000);
    public EnergyStorageExt energyStorage = new EnergyStorageExt(100000, 100000, 100000);
    private String customName;
    private IExtractorRecipe recipe;
    public int progress;

    public void func_73660_a() {
        boolean update = false;
        if (this.energyStorage.update) {
            update = true;
            this.energyStorage.update = false;
        }
        if (this.fluidTank.update) {
            update = true;
            this.detectRecipe();
            this.fluidTank.update = false;
        }
        if (this.recipe != null && this.canWork()) {
            ++this.progress;
            if (this.progress >= 100) {
                this.makeResult(this.recipe);
                this.progress = 0;
            }
        } else {
            this.progress = 0;
        }
        if (update) {
            this.func_70296_d();
        }
    }

    public void makeResult(IExtractorRecipe recipe) {
        if (recipe == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.energyStorage.extractEnergy(recipe.getRequiredEnergy(), false);
        if (recipe.getInputFluid() != null) {
            this.fluidTank.drain(recipe.getInputFluid(), true);
        }
        this.inputSlots.getStackInSlot(0).func_190918_g(recipe.getInputAmount());
        if (recipe.getInputContainer() != null) {
            this.inputSlots.getStackInSlot(1).func_190918_g(1);
        }
        Random random = new Random();
        float primary = random.nextFloat();
        float secondary = random.nextFloat();
        if (!recipe.getPrimaryResult().func_190926_b() && primary < recipe.getPrimaryChance()) {
            this.outputSlots.insertItem(0, recipe.getPrimaryResult().func_77946_l(), false);
        }
        if (!recipe.getSecondaryResult().func_190926_b() && secondary < recipe.getSecondaryChance()) {
            this.outputSlots.insertItem(1, recipe.getSecondaryResult().func_77946_l(), false);
        }
    }

    public boolean canWork() {
        int i;
        int max;
        ItemStack stack;
        if (this.recipe == null) {
            return false;
        }
        if (!this.recipe.getPrimaryResult().func_190926_b() && !this.outputSlots.getStackInSlot(0).func_190926_b()) {
            stack = this.outputSlots.getStackInSlot(0);
            if (stack.func_77973_b() != this.recipe.getPrimaryResult().func_77973_b()) {
                return false;
            }
            max = stack.func_77976_d();
            if (stack.func_190916_E() + this.recipe.getPrimaryResult().func_190916_E() > max) {
                return false;
            }
            i = this.recipe.getPrimaryResult().func_77960_j();
            if (i != Short.MAX_VALUE && i != stack.func_77960_j()) {
                return false;
            }
        }
        if (!this.recipe.getSecondaryResult().func_190926_b() && !this.outputSlots.getStackInSlot(1).func_190926_b()) {
            stack = this.outputSlots.getStackInSlot(1);
            if (stack.func_77973_b() != this.recipe.getSecondaryResult().func_77973_b()) {
                return false;
            }
            max = stack.func_77976_d();
            if (stack.func_190916_E() + this.recipe.getSecondaryResult().func_190916_E() > max) {
                return false;
            }
            i = this.recipe.getSecondaryResult().func_77960_j();
            if (i != Short.MAX_VALUE && i != stack.func_77960_j()) {
                return false;
            }
        }
        return ExtractorRecipeHandler.matches(this.recipe, this.inputSlots.getStackInSlot(0), this.inputSlots.getStackInSlot(1), this.fluidTank.getFluid(), this.energyStorage.getEnergyStored());
    }

    public void detectRecipe() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.recipe = ExtractorRecipeHandler.findExtractorRecipe(this.inputSlots.getStackInSlot(0), this.inputSlots.getStackInSlot(1), this.fluidTank.getFluid(), this.energyStorage.getEnergyStored());
    }

    public void setCustomInventoryName(String name) {
        this.customName = name;
    }

    public void dropAllItems(World worldIn, BlockPos pos) {
        CombinedInvWrapper handler = (CombinedInvWrapper)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            handler.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    public ITextComponent func_145748_c_() {
        return this.customName != null && !this.customName.isEmpty() ? new TextComponentString(this.customName) : new TextComponentTranslation("tile.extractor.name", new Object[0]);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(facing == null ? this.combinedSlots : (facing == EnumFacing.DOWN ? this.outputSlots : this.inputSlots));
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.energyStorage);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this.fluidTank);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.fluidContainerSlots.deserializeNBT(compound.func_74775_l("FluidContainerItems"));
        this.inputSlots.deserializeNBT(compound.func_74775_l("InputItems"));
        this.outputSlots.deserializeNBT(compound.func_74775_l("OutputItems"));
        this.energyStorage.deserializeNBT(compound);
        this.fluidTank.readFromNBT(compound.func_74775_l("FluidTank"));
        this.progress = compound.func_74762_e("Progress");
        if (compound.func_74764_b("CachedRecipe")) {
            this.recipe = ExtractorRecipeHandler.getRecipe(new ResourceLocation(compound.func_74779_i("CachedRecipe")));
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("FluidContainerItems", (NBTBase)this.fluidContainerSlots.serializeNBT());
        compound.func_74782_a("InputItems", (NBTBase)this.inputSlots.serializeNBT());
        compound.func_74782_a("OutputItems", (NBTBase)this.outputSlots.serializeNBT());
        compound.func_74768_a("Energy", this.energyStorage.getEnergyStored());
        compound.func_74782_a("FluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        compound.func_74768_a("Progress", this.progress);
        if (this.recipe != null) {
            compound.func_74778_a("CachedRecipe", this.recipe.getRegistryName().toString());
        }
        if (this.customName != null && !this.customName.isEmpty()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return super.func_189515_b(compound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }
}

