/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.utilities.items;

import java.util.HashMap;
import java.util.Map;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.util.helper.ItemHelper;
import lucraft.mods.lucraftcore.util.helper.StringHelper;
import lucraft.mods.lucraftcore.util.items.ItemBase;
import lucraft.mods.lucraftcore.util.items.ItemBaseEnergyStorage;
import lucraft.mods.lucraftcore.utilities.items.ItemHammer;
import lucraft.mods.lucraftcore.utilities.items.ItemInjection;
import lucraft.mods.lucraftcore.utilities.items.ItemInstruction;
import lucraft.mods.lucraftcore.utilities.items.ItemTriPolymer;
import lucraft.mods.lucraftcore.utilities.recipes.RecipeInstructionCloning;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class UtilitiesItems {
    public static Item HAMMER = new ItemHammer("hammer");
    public static Item WIRE_CUTTER = new ItemHammer("wire_cutter");
    public static Item INJECTION = new ItemInjection("injection");
    public static Item INSTRUCTION = new ItemInstruction("instruction");
    public static Item LV_CAPACITOR = new ItemBaseEnergyStorage("lv_capacitor", 100000).func_77637_a(LucraftCore.CREATIVE_TAB);
    public static Item MV_CAPACITOR = new ItemBaseEnergyStorage("mv_capacitor", 1000000).func_77637_a(LucraftCore.CREATIVE_TAB);
    public static Item HV_CAPACITOR = new ItemBaseEnergyStorage("hv_capacitor", 4000000).func_77637_a(LucraftCore.CREATIVE_TAB);
    public static Item SERVO_MOTOR = new ItemBase("servo_motor").func_77637_a(LucraftCore.CREATIVE_TAB);
    public static Item BASIC_CIRCUIT = new ItemBase("basic_circuit").func_77637_a(LucraftCore.CREATIVE_TAB);
    public static Item ADVANCED_CIRCUIT = new ItemBase("advanced_circuit").func_77637_a(LucraftCore.CREATIVE_TAB);
    public static Map<EnumDyeColor, ItemTriPolymer> TRI_POLYMER = new HashMap<EnumDyeColor, ItemTriPolymer>();

    @SubscribeEvent
    public void onRegisterItems(RegistryEvent.Register<Item> e) {
        e.getRegistry().register((IForgeRegistryEntry)HAMMER);
        e.getRegistry().register((IForgeRegistryEntry)WIRE_CUTTER);
        e.getRegistry().register((IForgeRegistryEntry)INJECTION);
        e.getRegistry().register((IForgeRegistryEntry)INSTRUCTION);
        e.getRegistry().register((IForgeRegistryEntry)LV_CAPACITOR);
        e.getRegistry().register((IForgeRegistryEntry)MV_CAPACITOR);
        e.getRegistry().register((IForgeRegistryEntry)HV_CAPACITOR);
        e.getRegistry().register((IForgeRegistryEntry)SERVO_MOTOR);
        e.getRegistry().register((IForgeRegistryEntry)BASIC_CIRCUIT);
        e.getRegistry().register((IForgeRegistryEntry)ADVANCED_CIRCUIT);
        for (EnumDyeColor color : EnumDyeColor.values()) {
            ItemTriPolymer item = new ItemTriPolymer(color);
            TRI_POLYMER.put(color, item);
            e.getRegistry().register((IForgeRegistryEntry)item);
            OreDictionary.registerOre((String)("triPolymer" + color.func_176610_l().substring(0, 1).toLowerCase() + color.func_176610_l().substring(1)), (Item)SERVO_MOTOR);
        }
        OreDictionary.registerOre((String)"servoMotor", (Item)SERVO_MOTOR);
        OreDictionary.registerOre((String)"circuitBasic", (Item)BASIC_CIRCUIT);
        OreDictionary.registerOre((String)"circuitAdvanced", (Item)ADVANCED_CIRCUIT);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRegisterModels(ModelRegistryEvent e) {
        ItemHelper.registerItemModel(HAMMER, "lucraftcore", "hammer");
        ItemHelper.registerItemModel(WIRE_CUTTER, "lucraftcore", "wire_cutter");
        ItemHelper.registerItemModel(INJECTION, "lucraftcore", "injection");
        ItemHelper.registerItemModel(INSTRUCTION, "lucraftcore", "instruction");
        ItemHelper.registerItemModel(LV_CAPACITOR, "lucraftcore", "lv_capacitor");
        ItemHelper.registerItemModel(MV_CAPACITOR, "lucraftcore", "mv_capacitor");
        ItemHelper.registerItemModel(HV_CAPACITOR, "lucraftcore", "hv_capacitor");
        ItemHelper.registerItemModel(SERVO_MOTOR, "lucraftcore", "servo_motor");
        ItemHelper.registerItemModel(BASIC_CIRCUIT, "lucraftcore", "basic_circuit");
        ItemHelper.registerItemModel(ADVANCED_CIRCUIT, "lucraftcore", "advanced_circuit");
        for (EnumDyeColor color : EnumDyeColor.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)TRI_POLYMER.get(color), (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("lucraftcore", "tri_polymer"), StringHelper.unlocalizedToResourceName(color.func_176762_d())));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRegisterRecipes(RegistryEvent.Register<IRecipe> e) {
        e.getRegistry().register(new RecipeInstructionCloning().setRegistryName("clone_instruction"));
    }
}

