/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.utilities.jei.extractor;

import java.util.List;
import javax.annotation.Nonnull;
import lucraft.mods.lucraftcore.util.helper.StringHelper;
import lucraft.mods.lucraftcore.utilities.jei.LCJEIPlugin;
import lucraft.mods.lucraftcore.utilities.jei.extractor.ExtractorRecipeWrapper;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.FluidStack;

public class ExtractorRecipeCategory
implements IRecipeCategory<ExtractorRecipeWrapper> {
    private static final int input1 = 0;
    private static final int input2 = 1;
    private static final int output1 = 2;
    private static final int output2 = 3;
    private final String title;
    private final IDrawable background;
    private final IDrawableAnimated arrow;
    private final IDrawableStatic tankOverlay;

    public ExtractorRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(LCJEIPlugin.TEXTURE, 0, 0, 135, 62);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(LCJEIPlugin.TEXTURE, 135, 0, 40, 23);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.tankOverlay = guiHelper.createDrawable(LCJEIPlugin.TEXTURE, 176, 1, 16, 60);
        this.title = "tile.extractor.name";
    }

    public void setRecipe(IRecipeLayout recipeLayout, ExtractorRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        itemStacks.init(0, true, 24, 21);
        itemStacks.init(1, true, 54, 21);
        fluidStacks.init(0, true, 1, 1, 16, 60, 5000, true, (IDrawable)this.tankOverlay);
        itemStacks.init(2, false, 88, 21);
        itemStacks.init(3, false, 113, 21);
        itemStacks.set(ingredients);
        fluidStacks.set(0, (List)ingredients.getInputs(FluidStack.class).get(0));
        itemStacks.addTooltipCallback((slotIndex, input, itemStack, list) -> {
            if (slotIndex == 2) {
                list.add(recipeWrapper.recipe.getPrimaryChance() * 100.0f + "%");
            }
            if (slotIndex == 3 && !recipeWrapper.recipe.getSecondaryResult().func_190926_b()) {
                list.add(recipeWrapper.recipe.getSecondaryChance() * 100.0f + "%");
            }
        });
    }

    public void drawExtras(Minecraft minecraft) {
        this.arrow.draw(minecraft, 43, 19);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public String getTitle() {
        return StringHelper.translateToLocal(this.title);
    }

    public String getUid() {
        return "lucraftcore.extractor";
    }

    public String getModName() {
        return "Lucraft: Core";
    }
}

