/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.utilities.jei.extractor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lucraft.mods.lucraftcore.util.helper.StringHelper;
import lucraft.mods.lucraftcore.utilities.recipes.ExtractorRecipeHandler;
import lucraft.mods.lucraftcore.utilities.recipes.IExtractorRecipe;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ExtractorRecipeWrapper
implements IRecipeWrapper {
    public final IExtractorRecipe recipe;

    public ExtractorRecipeWrapper(IExtractorRecipe recipe) {
        this.recipe = recipe;
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (ItemStack stack : this.recipe.getInput().func_193365_a()) {
            ItemStack s = stack.func_77946_l();
            s.func_190920_e(this.recipe.getInputAmount());
            inputs.add(s);
        }
        ingredients.setInputLists(ItemStack.class, Arrays.asList(Arrays.asList(inputs), Arrays.asList(this.recipe.getInputContainer().func_193365_a())));
        ingredients.setInput(FluidStack.class, (Object)this.recipe.getInputFluid());
        ingredients.setOutputLists(ItemStack.class, Arrays.asList(Arrays.asList(this.recipe.getPrimaryResult()), Arrays.asList(this.recipe.getSecondaryResult())));
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String s = StringHelper.translateToLocal("lucraftcore.info.energy_display", this.recipe.getRequiredEnergy(), "FE");
        minecraft.field_71466_p.func_78276_b(s, 67 - minecraft.field_71466_p.func_78256_a(s) / 2, recipeHeight - 11, 0x404040);
    }

    public static List<ExtractorRecipeWrapper> getRecipes() {
        ArrayList<ExtractorRecipeWrapper> recipes = new ArrayList<ExtractorRecipeWrapper>();
        for (IExtractorRecipe recipe : ExtractorRecipeHandler.getRecipes()) {
            recipes.add(new ExtractorRecipeWrapper(recipe));
        }
        return recipes;
    }
}

