/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.pymtech.abilities;

import lucraft.mods.lucraftcore.sizechanging.capabilities.CapabilitySizeChanging;
import lucraft.mods.lucraftcore.sizechanging.capabilities.ISizeChanging;
import lucraft.mods.lucraftcore.sizechanging.sizechanger.SizeChanger;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityAction;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityData;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataFloat;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.EnumSync;
import lucraft.mods.lucraftcore.superpowers.suitsets.SuitSet;
import lucraft.mods.lucraftcore.util.helper.PlayerHelper;
import lucraft.mods.lucraftcore.util.helper.StringHelper;
import lucraft.mods.lucraftcore.util.inventory.InventoryItem;
import lucraft.mods.pymtech.fluids.PTFluids;
import lucraft.mods.pymtech.helper.PTIconHelper;
import lucraft.mods.pymtech.items.ItemPymParticleArmor;
import lucraft.mods.pymtech.items.PTItems;
import lucraft.mods.pymtech.sounds.PTSoundEvents;
import lucraft.mods.pymtech.suitsets.SuitSetPymParticles;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.SizeChangerPymParticles;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AbilityPymParticleSize
extends AbilityAction {
    public static final AbilityData<Float> SIZE = new AbilityDataFloat("size").disableSaving().setSyncType(EnumSync.SELF).enableSetting("size", "Sets the size you want to change to");

    public AbilityPymParticleSize(EntityLivingBase entity) {
        super(entity);
    }

    public void registerData() {
        super.registerData();
        this.dataManager.register(SIZE, (Object)Float.valueOf(0.1f));
    }

    public boolean isUnlocked() {
        return super.isUnlocked() && !this.getChestplate().func_190926_b();
    }

    @SideOnly(value=Side.CLIENT)
    public void drawIcon(Minecraft mc, Gui gui, int x, int y) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
        mc.field_71446_o.func_110577_a(PTIconHelper.ICON_TEX);
        gui.func_73729_b(0, 0, ((Float)this.dataManager.get(SIZE)).floatValue() < 1.0f ? 0 : 32, 0, 32, 32);
        String s = "" + this.getSize();
        int length = mc.field_71466_p.func_78256_a(s);
        mc.field_71466_p.func_78276_b(s, 16 - length / 2, 25, 0xFEFEFE);
        GlStateManager.func_179121_F();
    }

    public String getDisplayName() {
        if (this.getChestplate().func_190926_b()) {
            return super.getDisplayName();
        }
        boolean shrink = ((Float)this.dataManager.get(SIZE)).floatValue() < 1.0f;
        String s = super.getDisplayName();
        ItemPymParticleArmor armor = (ItemPymParticleArmor)this.getChestplate().func_77973_b();
        FluidStack particles = armor.getPymParticles(this.getChestplate(), shrink);
        if (this.getChestplate().func_77978_p().func_74767_n("Infinite")) {
            return s + " (" + StringHelper.translateToLocal((String)"pymtech.info.infinite") + ")";
        }
        return s + " (" + (particles == null ? 0 : particles.amount) + "/" + armor.getCapacity(this.getChestplate(), shrink) + ")";
    }

    public ItemStack getChestplate() {
        return this.entity == null ? ItemStack.field_190927_a : (this.entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemPymParticleArmor ? this.entity.func_184582_a(EntityEquipmentSlot.CHEST) : ItemStack.field_190927_a);
    }

    public boolean action() {
        if (this.entity instanceof EntityPlayer) {
            PlayerHelper.playSound((World)this.entity.field_70170_p, (EntityPlayer)((EntityPlayer)this.entity), (double)this.entity.field_70165_t, (double)(this.entity.field_70163_u + (double)this.entity.func_70047_e()), (double)this.entity.field_70161_v, (SoundEvent)PTSoundEvents.BUTTON, (SoundCategory)SoundCategory.PLAYERS);
        }
        if (SuitSet.getSuitSet((EntityLivingBase)this.entity) instanceof SuitSetPymParticles) {
            InventoryItem inv;
            ItemStack regulator;
            ItemStack stack = this.getChestplate();
            float f = ((ISizeChanging)this.entity.getCapability(CapabilitySizeChanging.SIZE_CHANGING_CAP, null)).getSize() - this.getSize();
            FluidStack fluidStack = new FluidStack(f > 0.0f ? PTFluids.SHRINK_PYM_PARTICLES : PTFluids.GROW_PYM_PARTICLES, 500);
            if (f != 0.0f && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && !(regulator = (inv = ItemPymParticleArmor.getInventory(stack)).func_70301_a(0)).func_190926_b() && ItemPymParticleArmor.fitsInRegulatorSlot(regulator)) {
                boolean grow;
                boolean bl = grow = regulator.func_77973_b() == PTItems.GROW_DISC && f >= 0.0f;
                if (regulator.func_77973_b() == PTItems.SHRINK_DISC && f <= 0.0f) {
                    return false;
                }
                if (grow) {
                    return false;
                }
                if (regulator.func_190926_b() && f <= 0.0f) {
                    return false;
                }
                FluidStack drained = ((IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).drain(fluidStack, false);
                float size = regulator.func_190926_b() ? 0.1f : this.getSize();
                SizeChanger sizeChanger = SizeChangerPymParticles.PYM_PARTICLES;
                if (drained != null && drained.amount == 500) {
                    if (((ISizeChanging)this.entity.getCapability(CapabilitySizeChanging.SIZE_CHANGING_CAP, null)).setSize(size, sizeChanger)) {
                        ((IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).drain(fluidStack, true);
                        return true;
                    }
                } else {
                    if (this.entity instanceof EntityPlayer) {
                        ((EntityPlayer)this.entity).func_146105_b((ITextComponent)new TextComponentTranslation(f > 0.0f ? "pymtech.info.not_enough_shrink_pp" : "pymtech.info.not_enough_grow_pp", new Object[0]), true);
                    }
                    return false;
                }
            }
        }
        return false;
    }

    public float getSize() {
        float customSize;
        float playerSize = ((ISizeChanging)this.entity.getCapability(CapabilitySizeChanging.SIZE_CHANGING_CAP, null)).getSize();
        float f = customSize = !this.getChestplate().func_77942_o() || this.getChestplate().func_77978_p().func_74760_g("RegulatedSize") <= 0.0f ? 1.0f : this.getChestplate().func_77978_p().func_74760_g("RegulatedSize");
        if (playerSize < 1.0f && ((Float)this.dataManager.get(SIZE)).floatValue() > 1.0f || playerSize > 1.0f && ((Float)this.dataManager.get(SIZE)).floatValue() < 1.0f) {
            return 1.0f;
        }
        return customSize < 1.0f && ((Float)this.dataManager.get(SIZE)).floatValue() < 1.0f ? customSize : (customSize > 1.0f && ((Float)this.dataManager.get(SIZE)).floatValue() > 1.0f ? customSize : ((Float)this.dataManager.get(SIZE)).floatValue());
    }
}

