/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.pymtech.client.models;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.world.World;

public class CachedRender {
    private RenderInner render;
    private VertexBuffer vbo;
    private VertexFormat format;

    public CachedRender(VertexFormat format, RenderInner render) {
        this.format = format;
        this.render = render;
    }

    private void cache(World world, float partialTicks) {
        this.vbo = new VertexBuffer(this.format);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, this.format);
        this.render.render(this.format, buffer, world, partialTicks);
        buffer.func_178977_d();
        buffer.func_178965_a();
        this.vbo.func_181722_a(buffer.func_178966_f());
        buffer.func_178969_c(0.0, 0.0, 0.0);
    }

    public void render(World world, float partialTicks) {
        if (this.vbo == null) {
            this.cache(world, partialTicks);
        }
        GlStateManager.func_187410_q((int)32884);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187410_q((int)32888);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_187410_q((int)32888);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187410_q((int)32886);
        this.vbo.func_177359_a();
        this.setupArrayPointers();
        this.vbo.func_177358_a(7);
        OpenGlHelper.func_176072_g((int)OpenGlHelper.field_176089_P, (int)0);
        GlStateManager.func_179117_G();
        for (VertexFormatElement vertexformatelement : DefaultVertexFormats.field_176600_a.func_177343_g()) {
            VertexFormatElement.EnumUsage vertexformatelement$enumusage = vertexformatelement.func_177375_c();
            int k1 = vertexformatelement.func_177369_e();
            switch (vertexformatelement$enumusage) {
                case POSITION: {
                    GlStateManager.func_187429_p((int)32884);
                    break;
                }
                case UV: {
                    OpenGlHelper.func_77472_b((int)(OpenGlHelper.field_77478_a + k1));
                    GlStateManager.func_187429_p((int)32888);
                    OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                    break;
                }
                case COLOR: {
                    GlStateManager.func_187429_p((int)32886);
                    GlStateManager.func_179117_G();
                }
            }
        }
    }

    private void setupArrayPointers() {
        GlStateManager.func_187420_d((int)3, (int)5126, (int)28, (int)0);
        GlStateManager.func_187406_e((int)4, (int)5121, (int)28, (int)12);
        GlStateManager.func_187405_c((int)2, (int)5126, (int)28, (int)16);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_187405_c((int)2, (int)5122, (int)28, (int)24);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
    }

    public void reset() {
        if (this.vbo != null) {
            this.vbo.func_177362_c();
        }
        this.vbo = null;
    }

    public static interface RenderInner {
        public void render(VertexFormat var1, BufferBuilder var2, World var3, float var4);
    }
}

