/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.pymtech.items;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lucraft.mods.lucraftcore.superpowers.suitsets.ItemSuitSetArmor;
import lucraft.mods.lucraftcore.superpowers.suitsets.SuitSet;
import lucraft.mods.lucraftcore.util.helper.StringHelper;
import lucraft.mods.lucraftcore.util.inventory.InventoryItem;
import lucraft.mods.pymtech.fluids.PTFluids;
import lucraft.mods.pymtech.items.PTItems;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class ItemPymParticleArmor
extends ItemSuitSetArmor {
    public ItemPymParticleArmor(SuitSet suitSet, EntityEquipmentSlot slot) {
        super(suitSet, slot);
        if (slot == EntityEquipmentSlot.CHEST) {
            this.func_185043_a(new ResourceLocation("infinite"), (stack, world, entity) -> stack.func_77942_o() && stack.func_77978_p().func_74767_n("Infinite") ? 1.0f : 0.0f);
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        super.func_150895_a(tab, items);
        if (this.field_77881_a == EntityEquipmentSlot.CHEST && this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this);
            ((IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).fill(new FluidStack(PTFluids.SHRINK_PYM_PARTICLES, 5000), true);
            ((IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).fill(new FluidStack(PTFluids.GROW_PYM_PARTICLES, 5000), true);
            items.add((Object)stack);
            ItemStack infinite = stack.func_77946_l();
            NBTTagCompound nbt = infinite.func_77978_p();
            nbt.func_74757_a("Infinite", true);
            infinite.func_77982_d(nbt);
            items.add((Object)infinite);
        }
    }

    public boolean shouldShiftTooltipAppear(ItemStack stack, EntityPlayer player) {
        return this.field_77881_a == EntityEquipmentSlot.CHEST;
    }

    public List<String> getShiftToolTip(ItemStack stack, EntityPlayer player) {
        ArrayList<String> tooltip = new ArrayList<String>();
        if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            IFluidHandlerItem cap = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            for (int i = 0; i < cap.getTankProperties().length; ++i) {
                int amount;
                IFluidTankProperties properties = cap.getTankProperties()[i];
                String fluidName = i == 0 ? TextFormatting.RED + PTFluids.SHRINK_PYM_PARTICLES.getLocalizedName(null) : TextFormatting.BLUE + PTFluids.GROW_PYM_PARTICLES.getLocalizedName(null);
                int n = amount = properties.getContents() == null ? 0 : properties.getContents().amount;
                if (!stack.func_77978_p().func_74767_n("Infinite")) {
                    tooltip.add(fluidName + TextFormatting.DARK_GRAY + ": " + TextFormatting.GRAY + amount + TextFormatting.DARK_GRAY + "/" + TextFormatting.GRAY + properties.getCapacity());
                    continue;
                }
                tooltip.add(fluidName + TextFormatting.DARK_GRAY + ": " + TextFormatting.YELLOW + StringHelper.translateToLocal((String)"pymtech.info.infinite"));
            }
        }
        return tooltip;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (((Object)((Object)this)).getClass() == ItemPymParticleArmor.class && this.field_77881_a == EntityEquipmentSlot.CHEST) {
            return new PymParticleWrapper(stack, this);
        }
        return super.initCapabilities(stack, nbt);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        return super.getAttributeModifiers(slot, stack);
    }

    public int getCapacity(ItemStack stack, boolean shrink) {
        return 5000;
    }

    public FluidStack getPymParticles(ItemStack stack, boolean shrink) {
        String tag;
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (stack.func_77978_p().func_74767_n("Infinite")) {
            return new FluidStack(shrink ? PTFluids.SHRINK_PYM_PARTICLES : PTFluids.GROW_PYM_PARTICLES, this.getCapacity(stack, shrink));
        }
        String string = tag = shrink ? "ShrinkPymParticles" : "GrowPymParticles";
        if (!stack.func_77978_p().func_74764_b(tag)) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l(tag));
    }

    public int fill(ItemStack stack, FluidStack resource, boolean doFill, boolean shrink) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("Infinite")) {
            return 0;
        }
        FluidStack fluid = this.getPymParticles(stack, shrink);
        int capacity = this.getCapacity(stack, shrink);
        if (resource == null || resource.amount <= 0) {
            return 0;
        }
        if (!doFill) {
            if (fluid == null) {
                return Math.min(capacity, resource.amount);
            }
            if (!fluid.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(capacity - fluid.amount, resource.amount);
        }
        if (fluid == null) {
            fluid = new FluidStack(resource, Math.min(capacity, resource.amount));
            NBTTagCompound nbt = fluid.writeToNBT(new NBTTagCompound());
            stack.func_77978_p().func_74782_a(shrink ? "ShrinkPymParticles" : "GrowPymParticles", (NBTBase)nbt);
            return fluid.amount;
        }
        if (!fluid.isFluidEqual(resource)) {
            return 0;
        }
        int filled = capacity - fluid.amount;
        if (resource.amount < filled) {
            fluid.amount += resource.amount;
            filled = resource.amount;
        } else {
            fluid.amount = capacity;
        }
        NBTTagCompound nbt = fluid.writeToNBT(new NBTTagCompound());
        stack.func_77978_p().func_74782_a(shrink ? "ShrinkPymParticles" : "GrowPymParticles", (NBTBase)nbt);
        return filled;
    }

    public FluidStack drain(ItemStack stack, FluidStack resource, boolean doDrain, boolean shrink) {
        if (resource == null || !resource.isFluidEqual(this.getPymParticles(stack, shrink))) {
            return null;
        }
        return this.drain(stack, resource.amount, doDrain, shrink);
    }

    public FluidStack drain(ItemStack stack, int maxDrain, boolean doDrain, boolean shrink) {
        FluidStack fluid = this.getPymParticles(stack, shrink);
        if (stack.func_77978_p().func_74767_n("Infinite")) {
            return new FluidStack(shrink ? PTFluids.SHRINK_PYM_PARTICLES : PTFluids.GROW_PYM_PARTICLES, maxDrain);
        }
        if (fluid == null || maxDrain <= 0) {
            return null;
        }
        int drained = maxDrain;
        if (fluid.amount < drained) {
            drained = fluid.amount;
        }
        FluidStack fluidStack = new FluidStack(fluid, drained);
        if (doDrain) {
            fluid.amount -= drained;
            if (fluid.amount <= 0) {
                fluid = null;
            }
            NBTTagCompound nbt = fluid == null ? new NBTTagCompound() : fluid.writeToNBT(new NBTTagCompound());
            stack.func_77978_p().func_74782_a(shrink ? "ShrinkPymParticles" : "GrowPymParticles", (NBTBase)nbt);
        }
        return fluidStack;
    }

    public static boolean fitsInRegulatorSlot(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item == PTItems.SHRINK_DISC || item == PTItems.GROW_DISC || item == PTItems.REGULATOR;
    }

    public static InventoryItem getInventory(ItemStack stack) {
        InventoryItem inventoryItem = new InventoryItem(1, stack);
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("Items")) {
            inventoryItem.func_70299_a(0, new ItemStack(PTItems.REGULATOR));
        }
        return inventoryItem;
    }

    public class PymParticleWrapper
    implements IFluidHandlerItem,
    ICapabilityProvider {
        @Nonnull
        protected ItemStack container;
        protected ItemPymParticleArmor item;

        public PymParticleWrapper(ItemStack container, ItemPymParticleArmor item) {
            this.container = container;
            this.item = item;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.cast((Object)this);
            }
            return null;
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.container;
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{new FluidTankProperties(this.item.getPymParticles(this.getContainer(), true), this.item.getCapacity(this.getContainer(), true)), new FluidTankProperties(this.item.getPymParticles(this.getContainer(), false), this.item.getCapacity(this.getContainer(), false))};
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource.getFluid() == PTFluids.SHRINK_PYM_PARTICLES) {
                return this.item.fill(this.getContainer(), resource, doFill, true);
            }
            if (resource.getFluid() == PTFluids.GROW_PYM_PARTICLES) {
                return this.item.fill(this.getContainer(), resource, doFill, false);
            }
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource.getFluid() == PTFluids.SHRINK_PYM_PARTICLES) {
                return this.item.drain(this.getContainer(), resource, doDrain, true);
            }
            if (resource.getFluid() == PTFluids.GROW_PYM_PARTICLES) {
                return this.item.drain(this.getContainer(), resource, doDrain, false);
            }
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (this.drain(new FluidStack(PTFluids.SHRINK_PYM_PARTICLES, maxDrain), false) != null && this.drain((FluidStack)new FluidStack((Fluid)PTFluids.SHRINK_PYM_PARTICLES, (int)maxDrain), (boolean)false).amount > 0) {
                return this.drain(new FluidStack(PTFluids.SHRINK_PYM_PARTICLES, maxDrain), doDrain);
            }
            if (this.drain(new FluidStack(PTFluids.GROW_PYM_PARTICLES, maxDrain), false) != null && this.drain((FluidStack)new FluidStack((Fluid)PTFluids.GROW_PYM_PARTICLES, (int)maxDrain), (boolean)false).amount > 0) {
                return this.drain(new FluidStack(PTFluids.GROW_PYM_PARTICLES, maxDrain), doDrain);
            }
            return null;
        }
    }
}

