/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.pymtech.items;

import javax.annotation.Nullable;
import lucraft.mods.lucraftcore.util.items.ItemBase;
import lucraft.mods.pymtech.entities.EntityShrunkenStructure;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

public class ItemShrunkenStructure
extends ItemBase {
    public ItemShrunkenStructure(String name) {
        super(name);
        this.func_77625_d(1);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("ShrunkenStructure");
    }

    @Nullable
    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        EntityShrunkenStructure entity = new EntityShrunkenStructure(world, new ShrunkenStructure(itemstack.func_77978_p().func_74775_l("ShrunkenStructure")));
        entity.scale = 0.1f;
        entity.func_70107_b(location.field_70165_t, location.field_70163_u, location.field_70161_v);
        entity.field_70159_w = location.field_70159_w;
        entity.field_70181_x = location.field_70181_x;
        entity.field_70179_y = location.field_70179_y;
        return entity;
    }

    public boolean func_77651_p() {
        return super.func_77651_p();
    }

    public static ShrunkenStructure rotateCounterclockwise(ShrunkenStructure shrunkenStructure) {
        BlockPos newSize = new BlockPos(shrunkenStructure.getSize().func_177952_p(), shrunkenStructure.getSize().func_177956_o(), shrunkenStructure.getSize().func_177958_n());
        BlockData[][][] newBlocks = new BlockData[newSize.func_177958_n()][newSize.func_177956_o()][newSize.func_177952_p()];
        for (int x = 0; x < shrunkenStructure.getSize().func_177958_n(); ++x) {
            for (int y = 0; y < shrunkenStructure.getSize().func_177956_o(); ++y) {
                for (int z = 0; z < shrunkenStructure.getSize().func_177952_p(); ++z) {
                    BlockData block = shrunkenStructure.getData()[x][y][z];
                    if (block == null) continue;
                    newBlocks[z][y][newSize.func_177952_p() - 1 - x] = new BlockData(block.getBlock().func_185907_a(Rotation.COUNTERCLOCKWISE_90), block.getTileEntityData());
                }
            }
        }
        return new ShrunkenStructure(newBlocks, newSize);
    }

    public static BlockData[][][] getBlockData(NBTTagList list, BlockPos size) {
        BlockData[][][] data = new BlockData[size.func_177958_n()][size.func_177956_o()][size.func_177952_p()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound blockTag = list.func_150305_b(i);
            BlockPos pos = NBTUtil.func_186861_c((NBTTagCompound)blockTag.func_74775_l("Pos"));
            data[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()] = new BlockData(blockTag);
        }
        return data;
    }

    public static NBTTagList createBlockDataTag(BlockData[][][] data, BlockPos size) {
        NBTTagList list = new NBTTagList();
        for (int x = 0; x < size.func_177958_n(); ++x) {
            for (int y = 0; y < size.func_177956_o(); ++y) {
                for (int z = 0; z < size.func_177952_p(); ++z) {
                    BlockData d = data[x][y][z];
                    if (d == null) continue;
                    NBTTagCompound nbt = d.serializeNBT();
                    nbt.func_74782_a("Pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)new BlockPos(x, y, z)));
                    list.func_74742_a((NBTBase)nbt);
                }
            }
        }
        return list;
    }

    public static class BlockData
    implements INBTSerializable<NBTTagCompound> {
        protected IBlockState block;
        protected NBTTagCompound tileEntityData;

        public BlockData(IBlockState block, @Nullable NBTTagCompound tileEntityData) {
            this.block = block;
            this.tileEntityData = tileEntityData;
        }

        public BlockData(NBTTagCompound nbt) {
            this.deserializeNBT(nbt);
        }

        public IBlockState getBlock() {
            return this.block;
        }

        public NBTTagCompound getTileEntityData() {
            return this.tileEntityData;
        }

        public boolean hasTileEntity() {
            return this.getTileEntityData() != null;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("Block", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.block.func_177230_c())).toString());
            nbt.func_74774_a("BlockData", (byte)this.block.func_177230_c().func_176201_c(this.block));
            if (this.tileEntityData != null) {
                nbt.func_74782_a("TileEntity", (NBTBase)this.tileEntityData);
            }
            return nbt;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.block = ((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(nbt.func_74779_i("Block")))).func_176203_a((int)nbt.func_74771_c("BlockData"));
            if (nbt.func_74764_b("TileEntity")) {
                this.tileEntityData = nbt.func_74775_l("TileEntity");
            }
        }
    }

    public static class ShrunkenStructure
    implements INBTSerializable<NBTTagCompound> {
        protected BlockData[][][] data;
        protected BlockPos size;
        protected long id;

        public ShrunkenStructure(BlockData[][][] data, BlockPos size) {
            this.data = data;
            this.size = size;
            this.id = System.currentTimeMillis();
        }

        public ShrunkenStructure(NBTTagCompound nbt) {
            this.deserializeNBT(nbt);
        }

        public BlockData[][][] getData() {
            return this.data;
        }

        public BlockPos getSize() {
            return this.size;
        }

        public long getId() {
            return this.id;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("Blocks", (NBTBase)ItemShrunkenStructure.createBlockDataTag(this.data, this.size));
            nbt.func_74782_a("Size", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.size));
            nbt.func_74772_a("Id", this.id);
            return nbt;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.size = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("Size"));
            this.data = ItemShrunkenStructure.getBlockData(nbt.func_150295_c("Blocks", 10), this.size);
            this.id = nbt.func_74763_f("Id");
        }

        public boolean equals(Object obj) {
            return obj instanceof ShrunkenStructure && ((ShrunkenStructure)obj).getId() == this.getId();
        }
    }
}

