/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.pymtech.items;

import lucraft.mods.lucraftcore.superpowers.suitsets.SuitSet;
import lucraft.mods.lucraftcore.util.helper.PlayerHelper;
import lucraft.mods.lucraftcore.util.items.ItemBase;
import lucraft.mods.pymtech.PymTech;
import lucraft.mods.pymtech.sounds.PTSoundEvents;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class ItemShrunkenSuit
extends ItemBase {
    public ItemShrunkenSuit(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77637_a(PymTech.CREATIVE_TAB);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (SuitSet suitSet : SuitSet.REGISTRY) {
                ItemStack stack = new ItemStack((Item)this);
                ItemShrunkenSuit.storeSuit(stack, new ItemStack(suitSet.getHelmet()), new ItemStack(suitSet.getChestplate()), new ItemStack(suitSet.getLegs()), new ItemStack(suitSet.getBoots()));
                items.add((Object)stack);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack;
        boolean free = true;
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || (stack = ItemShrunkenSuit.getStoredItem(playerIn.func_184586_b(handIn), slot)).func_190926_b()) continue;
            free = free && playerIn.func_184582_a(slot).func_190926_b();
        }
        if (!free) {
            return new ActionResult(EnumActionResult.FAIL, (Object)playerIn.func_184586_b(handIn));
        }
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR) continue;
            stack = ItemShrunkenSuit.getStoredItem(playerIn.func_184586_b(handIn), slot);
            playerIn.func_184201_a(slot, stack);
        }
        PlayerHelper.playSoundToAll((World)playerIn.field_70170_p, (double)playerIn.field_70165_t, (double)playerIn.field_70163_u, (double)playerIn.field_70161_v, (double)50.0, (SoundEvent)PTSoundEvents.GROW, (SoundCategory)SoundCategory.PLAYERS);
        PlayerHelper.playSound((World)playerIn.field_70170_p, (EntityPlayer)playerIn, (double)playerIn.field_70165_t, (double)playerIn.field_70163_u, (double)playerIn.field_70161_v, (SoundEvent)PTSoundEvents.BUTTON, (SoundCategory)SoundCategory.PLAYERS);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)ItemStack.field_190927_a);
    }

    public static ItemStack storeSuit(ItemStack container, ItemStack helmet, ItemStack chest, ItemStack legs, ItemStack boots) {
        NBTTagCompound nbt;
        NBTTagCompound nBTTagCompound = nbt = container.func_77942_o() ? container.func_77978_p() : new NBTTagCompound();
        if (!helmet.func_190926_b()) {
            nbt.func_74782_a("Helmet", (NBTBase)helmet.serializeNBT());
        }
        if (!chest.func_190926_b()) {
            nbt.func_74782_a("Chestplate", (NBTBase)chest.serializeNBT());
        }
        if (!legs.func_190926_b()) {
            nbt.func_74782_a("Legs", (NBTBase)legs.serializeNBT());
        }
        if (!boots.func_190926_b()) {
            nbt.func_74782_a("Boots", (NBTBase)boots.serializeNBT());
        }
        container.func_77982_d(nbt);
        return container;
    }

    public static ItemStack getStoredItem(ItemStack container, EntityEquipmentSlot slot) {
        if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || container.func_190926_b() || !container.func_77942_o()) {
            return ItemStack.field_190927_a;
        }
        String key = slot == EntityEquipmentSlot.HEAD ? "Helmet" : (slot == EntityEquipmentSlot.CHEST ? "Chestplate" : (slot == EntityEquipmentSlot.LEGS ? "Legs" : "Boots"));
        return new ItemStack(container.func_77978_p().func_74775_l(key));
    }
}

