/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.pymtech.network;

import io.netty.buffer.ByteBuf;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.network.AbstractServerMessageHandler;
import lucraft.mods.pymtech.tileentities.TileEntityStructureShrinker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageStructureShrinkerSettings
implements IMessage {
    public BlockPos pos;
    public BlockPos area;
    public boolean showBox;

    public MessageStructureShrinkerSettings() {
    }

    public MessageStructureShrinkerSettings(BlockPos pos, BlockPos area, boolean showBox) {
        this.pos = pos;
        this.area = area;
        this.showBox = showBox;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = NBTUtil.func_186861_c((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)buf));
        this.area = NBTUtil.func_186861_c((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)buf));
        this.showBox = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)NBTUtil.func_186859_a((BlockPos)this.pos));
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)NBTUtil.func_186859_a((BlockPos)this.area));
        buf.writeBoolean(this.showBox);
    }

    public static class Handler
    extends AbstractServerMessageHandler<MessageStructureShrinkerSettings> {
        public IMessage handleServerMessage(EntityPlayer player, MessageStructureShrinkerSettings message, MessageContext ctx) {
            LucraftCore.proxy.getThreadFromContext(ctx).func_152344_a(() -> {
                TileEntity tileEntity = player.field_70170_p.func_175625_s(message.pos);
                if (tileEntity != null && tileEntity instanceof TileEntityStructureShrinker) {
                    ((TileEntityStructureShrinker)tileEntity).changeSettings(message.area, message.showBox);
                }
            });
            return null;
        }
    }
}

