/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.pymtech.suitsets;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lucraft.mods.lucraftcore.sizechanging.capabilities.CapabilitySizeChanging;
import lucraft.mods.lucraftcore.sizechanging.capabilities.ISizeChanging;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityEnergyBlast;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityFlight;
import lucraft.mods.lucraftcore.superpowers.abilities.predicates.AbilityCondition;
import lucraft.mods.lucraftcore.superpowers.effects.EffectVibrating;
import lucraft.mods.lucraftcore.superpowers.suitsets.ItemSuitSetArmor;
import lucraft.mods.lucraftcore.superpowers.suitsets.SuitSet;
import lucraft.mods.lucraftcore.util.helper.LCRenderHelper;
import lucraft.mods.lucraftcore.util.helper.PlayerHelper;
import lucraft.mods.lucraftcore.util.helper.StringHelper;
import lucraft.mods.lucraftcore.util.render.ModelCache;
import lucraft.mods.pymtech.abilities.AbilityPymParticleSize;
import lucraft.mods.pymtech.abilities.AbilityRegulator;
import lucraft.mods.pymtech.abilities.AbilityShrinkSuit;
import lucraft.mods.pymtech.client.models.ModelAntManHelmet;
import lucraft.mods.pymtech.client.models.ModelWaspChestplate;
import lucraft.mods.pymtech.items.ItemPymParticleArmor;
import lucraft.mods.pymtech.sounds.PTSoundEvents;
import lucraft.mods.pymtech.suitsets.PTSuitSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SuitSetPymParticles
extends PTSuitSet {
    public static final int ANIMATION_TIME = 20;
    protected String name;
    protected String desc;
    protected boolean helmetAnimation;
    protected NBTTagCompound nbt;
    public static Map<String, Object> SUIT_TEXTURES = new HashMap<String, Object>();

    public SuitSetPymParticles(String name, String desc, boolean helmetAnimation) {
        super(name);
        this.name = name;
        this.desc = desc;
        this.helmetAnimation = helmetAnimation;
        this.nbt = new NBTTagCompound();
        this.nbt.func_74757_a("protect_from_suffocating", true);
    }

    public NBTTagCompound getData() {
        return this.nbt;
    }

    public ItemArmor.ArmorMaterial getArmorMaterial(EntityEquipmentSlot slot) {
        if (this == PTSuitSet.ANT_MAN_2) {
            return ItemArmor.ArmorMaterial.DIAMOND;
        }
        return super.getArmorMaterial(slot);
    }

    public ItemSuitSetArmor createItem(SuitSet suitSet, EntityEquipmentSlot slot) {
        return (ItemSuitSetArmor)new ItemPymParticleArmor(suitSet, slot).setRegistryName(suitSet.getRegistryName().func_110624_b(), suitSet.getRegistryName().func_110623_a() + (slot == EntityEquipmentSlot.HEAD ? "_helmet" : (slot == EntityEquipmentSlot.CHEST ? "_chest" : (slot == EntityEquipmentSlot.LEGS ? "_legs" : "_boots"))));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, EntityEquipmentSlot slot) {
        if (slot == EntityEquipmentSlot.CHEST) {
            ModelLoader.setCustomModelResourceLocation((Item)this.getChestplate(), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().func_110624_b() + ":" + this.getUnlocalizedName() + "_chest"));
        } else {
            super.registerModel(item, slot);
        }
    }

    public boolean canOpenArmor(EntityEquipmentSlot slot) {
        return slot == EntityEquipmentSlot.HEAD;
    }

    public boolean hasGlowyThings(EntityLivingBase entity, EntityEquipmentSlot slot) {
        if (this == PTSuitSet.ANT_MAN_3 || this == PTSuitSet.WASP) {
            return slot == EntityEquipmentSlot.CHEST || slot == EntityEquipmentSlot.HEAD;
        }
        return slot == EntityEquipmentSlot.CHEST;
    }

    public List<String> getExtraDescription(ItemStack stack) {
        return Arrays.asList(StringHelper.translateToLocal((String)this.desc));
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(SuitSet suitSet, ItemStack stack, Entity entity, EntityEquipmentSlot slot, boolean light, boolean smallArms, boolean open) {
        String key = suitSet.getRegistryName().toString() + "_" + suitSet.getArmorModelScale(slot) + "_" + suitSet.getArmorTexturePath(stack, entity, slot, false, smallArms, open) + "_" + suitSet.getArmorTexturePath(stack, entity, slot, true, smallArms, open) + "_" + slot.toString() + "_" + smallArms + "_" + EffectVibrating.isVibrating((Entity)entity);
        ModelBase model = ModelCache.getModel((String)key);
        if (model != null && model instanceof ModelBiped) {
            return (ModelBiped)model;
        }
        return (ModelBiped)ModelCache.storeModel((String)key, (ModelBase)(slot == EntityEquipmentSlot.HEAD ? new ModelAntManHelmet(this.getArmorModelScale(slot), this.getArmorTexturePath(stack, entity, slot, false, smallArms, open), this.getArmorTexturePath(stack, entity, slot, true, smallArms, open), this, slot, smallArms, EffectVibrating.isVibrating((Entity)entity)) : (slot == EntityEquipmentSlot.CHEST && suitSet == PTSuitSet.WASP ? new ModelWaspChestplate(this.getArmorModelScale(slot), this.getArmorTexturePath(stack, entity, slot, false, smallArms, open), this.getArmorTexturePath(stack, entity, slot, true, smallArms, open), this, slot, smallArms, EffectVibrating.isVibrating((Entity)entity)) : super.getArmorModel(suitSet, stack, entity, slot, light, smallArms, open))));
    }

    public String getArmorTexturePath(ItemStack stack, Entity entity, EntityEquipmentSlot slot, boolean light, boolean smallArms, boolean open) {
        if (slot == EntityEquipmentSlot.HEAD && this.helmetAnimation) {
            return this.getModId() + ":textures/models/armor/" + this.getRegistryName().func_110623_a() + "/helmet" + (light ? "_lights" : "") + ".png";
        }
        return super.getArmorTexturePath(stack, entity, slot, light, smallArms, open);
    }

    public void onArmorToggled(Entity entity, ItemStack stack, EntityEquipmentSlot slot, boolean open) {
        PlayerHelper.playSoundToAll((World)entity.field_70170_p, (double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v, (double)50.0, (SoundEvent)(open ? PTSoundEvents.HELMET_OPENING : PTSoundEvents.HELMET_CLOSING), (SoundCategory)SoundCategory.PLAYERS);
    }

    public Ability.AbilityMap addDefaultAbilities(EntityLivingBase entity, Ability.AbilityMap abilities, Ability.EnumAbilityContext context) {
        abilities.put("pym_particle_size_shrink", new AbilityPymParticleSize(entity).setDataValue(AbilityPymParticleSize.SIZE, Float.valueOf(0.1f)).setDataValue(Ability.TITLE, (Object)new TextComponentTranslation("pymtech.info.shrink", new Object[0])));
        abilities.put("pym_particle_size_grow", new AbilityPymParticleSize(entity).setDataValue(AbilityPymParticleSize.SIZE, Float.valueOf(this == PTSuitSet.ANT_MAN || this == PTSuitSet.WASP ? 1.0f : 8.0f)).setDataValue(Ability.TITLE, (Object)new TextComponentTranslation("pymtech.info.grow", new Object[0])));
        abilities.put("regulator", new AbilityRegulator(entity).setDataValue(AbilityRegulator.ADVANCED, this == PTSuitSet.ANT_MAN_2));
        abilities.put("shrink_suit", new AbilityShrinkSuit(entity).setDataValue(AbilityShrinkSuit.NEEDS_PYM_PARTICLES, true));
        if (this == PTSuitSet.WASP) {
            abilities.put("energy_blast", new AbilityEnergyBlast(entity).setDataValue(AbilityEnergyBlast.DAMAGE, (Object)Float.valueOf(5.0f)).setDataValue(AbilityEnergyBlast.COLOR, (Object)new Color(0.34f, 0.3f, 0.05f)).setMaxCooldown(40));
            abilities.put("flight", new AbilityFlight(entity).setDataValue(AbilityFlight.SPEED, (Object)Float.valueOf(3.0f)).setDataValue(AbilityFlight.SPRINT_SPEED, (Object)Float.valueOf(10.0f)).setDataValue(AbilityFlight.ROTATE_ARMS, (Object)false).addCondition(new AbilityCondition(a -> ((ISizeChanging)a.getEntity().getCapability(CapabilitySizeChanging.SIZE_CHANGING_CAP, null)).getSize() <= 0.5f, (ITextComponent)new TextComponentString("SMALL"))));
        }
        return super.addDefaultAbilities(entity, abilities, context);
    }

    @SideOnly(value=Side.CLIENT)
    public void bindArmorTexture(SuitSet suitSet, Entity entity, float f, float f1, float f2, float f3, float f4, float f5, ResourceLocation normalTex, ResourceLocation glowTex, boolean glow, EntityEquipmentSlot slot, boolean smallArms) {
        if (slot == EntityEquipmentSlot.HEAD && this.helmetAnimation && entity instanceof EntityLivingBase) {
            ItemStack stack = ((EntityLivingBase)entity).func_184582_a(slot);
            int timer = 20 - (stack.func_77942_o() ? stack.func_77978_p().func_74762_e("OpenTimer") : 0);
            String key = suitSet.getRegistryName().toString() + (glow ? "glow" : "normal") + "_" + timer;
            if (timer == 20) {
                super.bindArmorTexture(suitSet, entity, f, f1, f2, f3, f4, f5, normalTex, glowTex, glow, slot, smallArms);
                return;
            }
            try {
                DynamicTexture t = null;
                if (SUIT_TEXTURES.containsKey(key)) {
                    t = (DynamicTexture)SUIT_TEXTURES.get(key);
                } else {
                    BufferedImage image = TextureUtil.func_177053_a((InputStream)Minecraft.func_71410_x().func_110442_L().func_110536_a(glow ? glowTex : normalTex).func_110527_b());
                    float progress1 = MathHelper.func_76131_a((float)((float)timer - 6.6666665f), (float)0.0f, (float)13.333334f) / 13.333334f;
                    LCRenderHelper.animY((BufferedImage)image, (int)8, (int)0, (int)16, (int)16, (float)progress1);
                    float progress2 = MathHelper.func_76131_a((float)timer, (float)0.0f, (float)6.6666665f) / 6.6666665f;
                    LCRenderHelper.animY((BufferedImage)image, (int)24, (int)14, (int)32, (int)8, (float)progress2);
                    if (timer < 19) {
                        LCRenderHelper.setOpacity((BufferedImage)image, (int)0, (int)51, (int)8, (int)55, (float)0.0f);
                        LCRenderHelper.setOpacity((BufferedImage)image, (int)0, (int)42, (int)12, (int)44, (float)0.0f);
                    }
                    if (timer != 20) {
                        LCRenderHelper.setOpacity((BufferedImage)image, (int)16, (int)4, (int)24, (int)8, (float)0.0f);
                    }
                    if ((float)timer < 7.0f) {
                        LCRenderHelper.setOpacity((BufferedImage)image, (int)11, (int)45, (int)21, (int)50, (float)0.0f);
                    }
                    if (timer < 10) {
                        LCRenderHelper.setOpacity((BufferedImage)image, (int)0, (int)32, (int)12, (int)38, (float)0.0f);
                    }
                    if ((float)timer < 13.0f) {
                        LCRenderHelper.setOpacity((BufferedImage)image, (int)0, (int)45, (int)10, (int)50, (float)0.0f);
                    }
                    int length = MathHelper.func_76125_a((int)timer, (int)0, (int)7);
                    for (int x = 0; x < 8; ++x) {
                        for (int y = 8; y < 16; ++y) {
                            int y_ = y - 8;
                            if (x + y_ <= length + 1 || !((float)timer - 6.0f < (float)x)) continue;
                            image.setRGB(x, 16 - y_ - 1, 0);
                            image.setRGB(23 - x, 16 - y_ - 1, 0);
                        }
                    }
                    t = new DynamicTexture(image);
                    SUIT_TEXTURES.put(key, t);
                }
                GlStateManager.func_179144_i((int)t.func_110552_b());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            super.bindArmorTexture(suitSet, entity, f, f1, f2, f3, f4, f5, normalTex, glowTex, glow, slot, smallArms);
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        ItemSuitSetArmor item = (ItemSuitSetArmor)itemStack.func_77973_b();
        if (this.helmetAnimation && item.field_77881_a == EntityEquipmentSlot.HEAD && itemStack.func_77942_o()) {
            NBTTagCompound nbt = itemStack.func_77978_p();
            int timer = nbt.func_74762_e("OpenTimer");
            boolean b = false;
            if (timer < 20 && item.isArmorOpen((Entity)player, itemStack)) {
                ++timer;
                b = true;
            } else if (timer > 0 && !item.isArmorOpen((Entity)player, itemStack)) {
                --timer;
                b = true;
            }
            if (b) {
                nbt.func_74768_a("OpenTimer", timer);
                itemStack.func_77982_d(nbt);
            }
        }
    }
}

