/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import lucraft.mods.lucraftcore.karma.potions.PotionKnockOut;
import lucraft.mods.lucraftcore.network.LCPacketDispatcher;
import lucraft.mods.lucraftcore.sizechanging.capabilities.ISizeChanging;
import lucraft.mods.lucraftcore.sizechanging.entities.EntitySizeChanging;
import lucraft.mods.lucraftcore.sizechanging.sizechanger.DefaultSizeChanger;
import lucraft.mods.lucraftcore.sizechanging.sizechanger.SizeChanger;
import lucraft.mods.lucraftcore.superpowers.render.SuperpowerRenderLayer;
import lucraft.mods.lucraftcore.superpowers.suitsets.SuitSet;
import lucraft.mods.lucraftcore.util.attributes.LCAttributes;
import lucraft.mods.lucraftcore.util.helper.PlayerHelper;
import lucraft.mods.lucraftcore.util.items.OpenableArmor;
import lucraft.mods.lucraftcore.util.network.MessageSyncPotionEffects;
import lucraft.mods.pymtech.sounds.PTSoundEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(modid="pymtech")
public class SizeChangerPymParticles
extends DefaultSizeChanger {
    public static final DamageSource SUFFOCATE = new DamageSource("suffocate").func_76348_h();
    public static final SizeChanger PYM_PARTICLES = (SizeChanger)new SizeChangerPymParticles().setRegistryName("pymtech", "pym_particles");

    @SubscribeEvent
    public static void onRegisterSizeChanger(RegistryEvent.Register<SizeChanger> e) {
        e.getRegistry().register((IForgeRegistryEntry)PYM_PARTICLES);
    }

    public int getSizeChangingTime(EntityLivingBase entity, ISizeChanging data, float estimatedSize) {
        return 10;
    }

    public void onSizeChanged(EntityLivingBase entity, ISizeChanging data, float size) {
        AbstractAttributeMap map = entity.func_110140_aT();
        this.setAttribute(map, SharedMonsterAttributes.field_111263_d, size > 1.0f ? 0.0 : (double)(size - 1.0f) * 0.5, size > 1.0f ? 0 : 2, SizeChanger.ATTRIBUTE_UUID);
        this.setAttribute(map, LCAttributes.JUMP_HEIGHT, size > 1.0f ? (double)(size - 1.0f) * 1.0 : (double)(size == 1.0f ? 0.0f : size), 0, SizeChanger.ATTRIBUTE_UUID);
        this.setAttribute(map, LCAttributes.FALL_RESISTANCE, size > 1.0f ? (double)(1.0f / size) : (double)size, 1, SizeChanger.ATTRIBUTE_UUID);
        this.setAttribute(map, LCAttributes.STEP_HEIGHT, size, 1, SizeChanger.ATTRIBUTE_UUID);
        this.setAttribute(map, SharedMonsterAttributes.field_111264_e, size > 1.0f ? (double)(size - 1.0f) * 1.0 : (double)(size == 1.0f ? 0.0f : (1.0f - size) * 10.0f), 0, SizeChanger.ATTRIBUTE_UUID);
        this.setAttribute(map, EntityPlayer.REACH_DISTANCE, (double)(size - 1.0f) * 1.0, 0, SizeChanger.ATTRIBUTE_UUID);
        this.setAttribute(map, SharedMonsterAttributes.field_111266_c, (double)(size - 1.0f) * 0.5, 0, SizeChanger.ATTRIBUTE_UUID);
        if (entity.field_70170_p.field_72995_K && entity.field_70173_aa % 2 == 0) {
            data.spawnEntity(data.getSizeChanger(), 10, size);
        }
    }

    public void onUpdate(EntityLivingBase entity, ISizeChanging data, float size) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if ((size < 0.5f || size > 3.0f) && entity instanceof EntityPlayer) {
            SuitSet suitSet = SuitSet.getSuitSet((EntityLivingBase)entity);
            ItemStack helmet = entity.func_184582_a(EntityEquipmentSlot.HEAD);
            if (suitSet == null || helmet.func_190926_b() || suitSet.getData() == null || !suitSet.getData().func_74767_n("protect_from_suffocating") || helmet.func_77973_b() instanceof OpenableArmor.IOpenableArmor && ((OpenableArmor.IOpenableArmor)helmet.func_77973_b()).isArmorOpen((Entity)entity, helmet)) {
                entity.func_70097_a(SUFFOCATE, 1.0f);
            }
        }
        String nbtKey = "pymtech:PassOutTimer";
        if (size > 1.0f) {
            int timer = (int)((float)entity.getEntityData().func_74762_e(nbtKey) + size);
            entity.getEntityData().func_74768_a(nbtKey, timer);
            if (timer >= 9600) {
                entity.func_70690_d(new PotionEffect((Potion)PotionKnockOut.POTION_KNOCK_OUT, 20));
                entity.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 20));
                LCPacketDispatcher.sendToAll((IMessage)new MessageSyncPotionEffects(entity));
                if (timer >= 12000) {
                    data.setSize(1.0f, (SizeChanger)this);
                }
            }
        } else if (entity.getEntityData().func_74762_e(nbtKey) > 0) {
            entity.getEntityData().func_74768_a(nbtKey, 0);
        }
    }

    public boolean start(EntityLivingBase entity, ISizeChanging data, float size, float estimatedSize) {
        PlayerHelper.playSoundToAll((World)entity.field_70170_p, (double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v, (double)50.0, (SoundEvent)(estimatedSize < size ? PTSoundEvents.SHRINK : PTSoundEvents.GROW), (SoundCategory)SoundCategory.NEUTRAL);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderEntity(EntitySizeChanging entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (entity.renderer == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179147_l();
        float alpha = 1.0f - (float)entity.field_70173_aa / (float)entity.lifeTime;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha / 1.4f));
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(-1.4375f * entity.size + 0.0f), (float)0.0f);
        GlStateManager.func_179114_b((float)entity.parent.field_70761_aq, (float)0.0f, (float)1.0f, (float)0.0f);
        float f = entity.size;
        GlStateManager.func_179152_a((float)f, (float)f, (float)f);
        entity.renderer.func_77041_b(entity.parent, partialTicks);
        GL11.glPolygonMode((int)1032, (int)6913);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(SuperpowerRenderLayer.WHITE_TEX);
        entity.renderer.func_177087_b().func_78088_a((Entity)entity.parent, entity.field_184619_aG, entity.field_70721_aZ, entity.ageInTicks, entity.netHeadYaw, entity.headPitch, entity.scale);
        GL11.glPolygonMode((int)1032, (int)6914);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha / 1.6f));
        entity.renderer.func_177087_b().func_78088_a((Entity)entity.parent, entity.field_184619_aG, entity.field_70721_aZ, entity.ageInTicks, entity.netHeadYaw, entity.headPitch, entity.scale);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }
}

