/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.pymtech.block;

import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.threetag.pymtech.tileentity.StructureShrinkerTileEntity;
import net.threetag.threecore.block.MachineBlock;
import net.threetag.threecore.util.BlockUtil;
import net.threetag.threecore.util.TCFluidUtil;

public class StructureShrinkerBlock
extends ContainerBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;

    public StructureShrinkerBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new StructureShrinkerTileEntity();
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (world.field_72995_K) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        AtomicReference result = new AtomicReference();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && FluidUtil.getFluidHandler((ItemStack)stack).isPresent()) {
            tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, rayTraceResult.func_216354_b()).ifPresent(fluidHandler -> player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> result.set(TCFluidUtil.interactWithFluidHandler((ItemStack)stack, (IFluidHandler)fluidHandler, (IItemHandler)itemHandler, (PlayerEntity)player))));
        }
        if (result.get() != null && ((FluidActionResult)result.get()).isSuccess()) {
            player.func_184611_a(hand, ((FluidActionResult)result.get()).getResult());
        } else {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this.func_220052_b(state, world, pos), (BlockPos)pos);
        }
        return true;
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        if (!world.func_201670_d() && world instanceof World && ((World)world).func_175640_z(pos) && world.func_175625_s(pos) instanceof StructureShrinkerTileEntity) {
            ((StructureShrinkerTileEntity)world.func_175625_s(pos)).shrink(null);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext selectionContext) {
        return MachineBlock.SHAPE;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader blockReader, BlockPos pos) {
        return MachineBlock.INSIDE;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        TileEntity tileEntity;
        if (stack.func_82837_s() && (tileEntity = world.func_175625_s(pos)) instanceof LockableTileEntity) {
            ((LockableTileEntity)tileEntity).func_213903_a(stack.func_200301_q());
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity != null) {
                tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(i -> BlockUtil.dropInventoryItems((World)worldIn, (BlockPos)pos, (IItemHandler)i));
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        return BlockUtil.calcRedstone((TileEntity)world.func_175625_s(pos));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }
}

