/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.pymtech.client.renderer.item;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.threetag.pymtech.PymTech;
import net.threetag.pymtech.item.ShrunkenStructureItem;
import net.threetag.pymtech.network.RequestShrunkenStructureMessage;
import net.threetag.pymtech.storage.ShrunkenStructureData;

public class ShrunkenStructureItemRenderer
extends ItemStackTileEntityRenderer {
    public static List<Integer> requested = Lists.newLinkedList();

    public void func_179022_a(ItemStack stack) {
        ShrunkenStructureData shrunkenStructure = ShrunkenStructureItem.get((World)Minecraft.func_71410_x().field_71441_e, stack);
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)0.5f, (float)0.0f, (float)0.5f);
        if (shrunkenStructure != null) {
            float f = 1.0f / (float)Math.max(shrunkenStructure.getSize().func_177958_n(), Math.max(shrunkenStructure.getSize().func_177956_o(), shrunkenStructure.getSize().func_177952_p()));
            GlStateManager.scalef((float)f, (float)f, (float)f);
        }
        ShrunkenStructureItemRenderer.render(shrunkenStructure, stack.func_196082_o().func_74762_e("ShrunkenStructure"), 1.0f, false);
        GlStateManager.popMatrix();
    }

    public static void render(ShrunkenStructureData shrunkenStructure, int id, float scale, boolean trail) {
        if (shrunkenStructure != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            if (!ShrunkenStructureItemRenderer.renderStructure(shrunkenStructure, shrunkenStructure.getSize(), scale, (World)Minecraft.func_71410_x().field_71441_e, 0.0f, trail)) {
                ShrunkenStructureItemRenderer.storeAndRender((World)Minecraft.func_71410_x().field_71441_e, Minecraft.func_71410_x().field_71439_g.func_180425_c(), shrunkenStructure, 0.0f, scale, trail);
            }
        } else if (!requested.contains(id)) {
            PymTech.NETWORK_CHANNEL.sendToServer((Object)new RequestShrunkenStructureMessage(id));
            requested.add(id);
        }
    }

    public static boolean renderStructure(ShrunkenStructureData data, BlockPos size, float scale, World world, float partialTicks, boolean trail) {
        if (data.renderer == null) {
            return false;
        }
        GlStateManager.pushMatrix();
        GlStateManager.scalef((float)scale, (float)scale, (float)scale);
        GlStateManager.translated((double)((double)(-size.func_177958_n()) / 2.0), (double)0.0, (double)((double)(-size.func_177952_p()) / 2.0));
        if (!trail) {
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.func_74518_a();
            GlStateManager.blendFunc((int)770, (int)771);
            GlStateManager.enableBlend();
            if (Minecraft.func_71379_u()) {
                GlStateManager.shadeModel((int)7425);
            } else {
                GlStateManager.shadeModel((int)7424);
            }
        }
        data.renderer.render(world, partialTicks);
        if (!trail) {
            RenderHelper.func_74519_b();
            GlStateManager.clearCurrentColor();
        }
        GlStateManager.popMatrix();
        return true;
    }

    public static void storeAndRender(World world, BlockPos pos, ShrunkenStructureData shrunkenStructure, float partialTicks, float scale, boolean trail) {
        if (shrunkenStructure.renderer == null) {
            CachedRender cachedRender;
            shrunkenStructure.renderer = cachedRender = new CachedRender(DefaultVertexFormats.field_176600_a, (format, buffer, theWorld, thePartialTicks) -> {
                BlockPos size = shrunkenStructure.getSize();
                for (int x = 0; x < size.func_177958_n(); ++x) {
                    for (int y = 0; y < size.func_177956_o(); ++y) {
                        for (int z = 0; z < size.func_177952_p(); ++z) {
                            ShrunkenStructureData.BlockData data = shrunkenStructure.getBlockData()[x][y][z];
                            if (data == null || data.getBlockState() == null || data.getBlockState().func_196958_f() || data.getBlockState().func_185901_i() == BlockRenderType.INVISIBLE) continue;
                            BlockState state = data.getBlockState();
                            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
                            if (state.func_185901_i() != BlockRenderType.MODEL) continue;
                            BlockPos p = new BlockPos(x, y, z);
                            blockrendererdispatcher.func_175019_b().renderModel((IEnviromentBlockReader)new ShrunkenStructureAccess(world, pos, shrunkenStructure), blockrendererdispatcher.func_184389_a(state), state, p, buffer, false, new Random(), 0L, (IModelData)EmptyModelData.INSTANCE);
                        }
                    }
                }
            });
            ShrunkenStructureItemRenderer.renderStructure(shrunkenStructure, shrunkenStructure.getSize(), scale, world, partialTicks, trail);
        } else {
            ShrunkenStructureItemRenderer.renderStructure(shrunkenStructure, shrunkenStructure.getSize(), scale, world, partialTicks, trail);
        }
    }

    public static interface RenderInner {
        public void render(VertexFormat var1, BufferBuilder var2, World var3, float var4);
    }

    public static class CachedRender {
        private RenderInner render;
        private VertexBuffer vbo;
        private VertexFormat format;

        public CachedRender(VertexFormat format, RenderInner render) {
            this.format = format;
            this.render = render;
        }

        private void cache(World world, float partialTicks) {
            this.vbo = new VertexBuffer(this.format);
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            buffer.func_181668_a(7, this.format);
            this.render.render(this.format, buffer, world, partialTicks);
            buffer.func_178977_d();
            buffer.func_178965_a();
            this.vbo.func_181722_a(buffer.func_178966_f());
            buffer.func_178969_c(0.0, 0.0, 0.0);
        }

        public void render(World world, float partialTicks) {
            if (this.vbo == null) {
                this.cache(world, partialTicks);
            }
            GlStateManager.enableClientState((int)32884);
            GLX.glClientActiveTexture((int)GLX.GL_TEXTURE0);
            GlStateManager.enableClientState((int)32888);
            GLX.glClientActiveTexture((int)GLX.GL_TEXTURE1);
            GlStateManager.enableClientState((int)32888);
            GLX.glClientActiveTexture((int)GLX.GL_TEXTURE0);
            GlStateManager.enableClientState((int)32886);
            this.vbo.func_177359_a();
            this.setupArrayPointers();
            this.vbo.func_177358_a(7);
            GLX.glBindBuffer((int)GLX.GL_ARRAY_BUFFER, (int)0);
            GlStateManager.clearCurrentColor();
            for (VertexFormatElement vertexformatelement : DefaultVertexFormats.field_176600_a.func_177343_g()) {
                VertexFormatElement.Usage usage = vertexformatelement.func_177375_c();
                int k1 = vertexformatelement.func_177369_e();
                switch (usage) {
                    case POSITION: {
                        GlStateManager.disableClientState((int)32884);
                        break;
                    }
                    case UV: {
                        GLX.glClientActiveTexture((int)(GLX.GL_TEXTURE0 + k1));
                        GlStateManager.disableClientState((int)32888);
                        GLX.glClientActiveTexture((int)GLX.GL_TEXTURE0);
                        break;
                    }
                    case COLOR: {
                        GlStateManager.disableClientState((int)32886);
                        GlStateManager.clearCurrentColor();
                    }
                }
            }
        }

        private void setupArrayPointers() {
            GlStateManager.vertexPointer((int)3, (int)5126, (int)28, (int)0);
            GlStateManager.colorPointer((int)4, (int)5121, (int)28, (int)12);
            GlStateManager.texCoordPointer((int)2, (int)5126, (int)28, (int)16);
            GLX.glClientActiveTexture((int)GLX.GL_TEXTURE1);
            GlStateManager.texCoordPointer((int)2, (int)5122, (int)28, (int)24);
            GLX.glClientActiveTexture((int)GLX.GL_TEXTURE0);
        }

        public void reset() {
            if (this.vbo != null) {
                this.vbo.func_177362_c();
            }
            this.vbo = null;
        }
    }

    public static class ShrunkenStructureAccess
    implements IEnviromentBlockReader {
        protected World world;
        protected BlockPos pos;
        protected ShrunkenStructureData shrunkenStructure;
        protected int volume;

        public ShrunkenStructureAccess(World world, BlockPos pos, ShrunkenStructureData shrunkenStructure) {
            this.world = world;
            this.pos = pos;
            this.shrunkenStructure = shrunkenStructure;
            this.volume = shrunkenStructure.getSize().func_177958_n() * shrunkenStructure.getSize().func_177956_o() * shrunkenStructure.getSize().func_177952_p();
        }

        public Biome func_180494_b(BlockPos blockPos) {
            return Minecraft.func_71410_x().field_71439_g.func_130014_f_().func_180494_b(Minecraft.func_71410_x().field_71439_g.func_180425_c());
        }

        public int func_175642_b(LightType lightType, BlockPos blockPos) {
            return this.world.func_175642_b(lightType, this.pos);
        }

        @Nullable
        public TileEntity func_175625_s(BlockPos blockPos) {
            return null;
        }

        public BlockState func_180495_p(BlockPos blockPos) {
            if (this.pos.func_177958_n() < 0 || this.pos.func_177956_o() < 0 || this.pos.func_177952_p() < 0 || this.pos.func_177958_n() > this.shrunkenStructure.getSize().func_177958_n() - 1 || this.pos.func_177956_o() > this.shrunkenStructure.getSize().func_177956_o() - 1 || this.pos.func_177952_p() > this.shrunkenStructure.getSize().func_177952_p() - 1) {
                return Blocks.field_150350_a.func_176223_P();
            }
            ShrunkenStructureData.BlockData data = this.shrunkenStructure.getBlockData()[this.pos.func_177958_n()][this.pos.func_177956_o()][this.pos.func_177952_p()];
            return data == null ? Blocks.field_150350_a.func_176223_P() : data.getBlockState();
        }

        public IFluidState func_204610_c(BlockPos blockPos) {
            return Fluids.field_204541_a.func_207188_f();
        }
    }
}

