/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.pymtech.item;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.threetag.pymtech.entity.ShrunkenStructureEntity;
import net.threetag.pymtech.item.PTItems;
import net.threetag.pymtech.sizechangetype.PTSizeChangeTypes;
import net.threetag.pymtech.storage.ShrunkenStructureData;
import net.threetag.threecore.capability.CapabilitySizeChanging;
import net.threetag.threecore.entity.SolidItemEntity;
import net.threetag.threecore.item.SolidItem;

public class ShrunkenStructureItem
extends SolidItem {
    public ShrunkenStructureItem(Item.Properties properties) {
        super(properties);
    }

    @Nullable
    public EntitySize getEntitySize(SolidItemEntity entity, ItemStack stack) {
        ShrunkenStructureData data = ShrunkenStructureItem.get(entity.field_70170_p, stack);
        if (data == null) {
            return super.getEntitySize(entity, stack);
        }
        float width = Math.max(data.getSize().func_177958_n(), data.getSize().func_177952_p());
        return new EntitySize(width, (float)data.getSize().func_177956_o(), false);
    }

    @Nullable
    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        ShrunkenStructureEntity entity = new ShrunkenStructureEntity(world, location.field_70165_t, location.field_70163_u, location.field_70161_v, itemstack);
        entity.func_213317_d(location.func_213322_ci());
        entity.getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(sizeChanging -> sizeChanging.setSizeDirectly(PTSizeChangeTypes.PYM_PARTICLES, 0.1f));
        if (location instanceof ItemEntity) {
            entity.setOwnerId(((ItemEntity)location).func_200215_l());
            entity.setThrowerId(((ItemEntity)location).func_200214_m());
        }
        return entity;
    }

    public void func_150895_a(ItemGroup itemGroup, NonNullList<ItemStack> items) {
    }

    public static ItemStack create(ShrunkenStructureData data) {
        ItemStack stack = new ItemStack((IItemProvider)PTItems.SHRUNKEN_STRUCTURE.get());
        stack.func_196082_o().func_74768_a("ShrunkenStructure", data.getId());
        return stack;
    }

    public static ShrunkenStructureData get(World world, ItemStack stack) {
        return stack.func_190926_b() ? null : ShrunkenStructureData.get(world, stack.func_196082_o().func_74762_e("ShrunkenStructure"));
    }

    public static ShrunkenStructureData getOrCreate(World world, ItemStack stack, Supplier<ShrunkenStructureData> supplier) {
        ShrunkenStructureData data = ShrunkenStructureItem.get(world, stack);
        if (data == null || data.isEmpty()) {
            ShrunkenStructureData data1 = supplier.get();
            ShrunkenStructureData.register(world, data1);
            return data1;
        }
        return data;
    }
}

