/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.pymtech.network;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.threetag.pymtech.ability.IAdvancedRegulatorAbility;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityHelper;

public class SetRegulatedSizeMessage {
    public String abilityId;
    public float size;

    public SetRegulatedSizeMessage(String abilityId, float size) {
        this.abilityId = abilityId;
        this.size = size;
    }

    public SetRegulatedSizeMessage(PacketBuffer buf) {
        this.abilityId = buf.func_150789_c(64);
        this.size = buf.readFloat();
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_180714_a(this.abilityId);
        buf.writeFloat(this.size);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Ability ability;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (ability = AbilityHelper.getAbilityById((LivingEntity)player, (String)this.abilityId, null)) instanceof IAdvancedRegulatorAbility) {
                ((IAdvancedRegulatorAbility)ability).setRegulatedSize(this.size);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

