/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.pymtech.tileentity;

import com.mojang.authlib.GameProfile;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.threetag.pymtech.block.PTBlocks;
import net.threetag.pymtech.config.PTServerConfig;
import net.threetag.pymtech.container.StructureShrinkerContainer;
import net.threetag.pymtech.entity.ShrunkenStructureEntity;
import net.threetag.pymtech.fluid.PTFluids;
import net.threetag.pymtech.item.ShrunkenStructureItem;
import net.threetag.pymtech.sizechangetype.PTSizeChangeTypes;
import net.threetag.pymtech.storage.ShrunkenStructureData;
import net.threetag.pymtech.storage.ShrunkenStructureIdTracker;
import net.threetag.pymtech.util.BlockUtil;
import net.threetag.threecore.capability.CapabilitySizeChanging;
import net.threetag.threecore.fluid.FluidTankExt;
import net.threetag.threecore.item.ItemStackHandlerExt;
import net.threetag.threecore.tileentity.MachineTileEntity;
import net.threetag.threecore.util.PlayerUtil;
import net.threetag.threecore.util.TCFluidUtil;
import net.threetag.threecore.util.energy.IEnergyConfig;

public class StructureShrinkerTileEntity
extends MachineTileEntity {
    public static final int TANK_CAPACITY = 5000;
    private BlockPos selectionStart = this.func_174877_v();
    private BlockPos selectionEnd = this.func_174877_v();
    protected final IIntArray intArray = new IIntArray(){

        public int func_221476_a(int i) {
            switch (i) {
                case 0: {
                    return StructureShrinkerTileEntity.this.energyStorage.getEnergyStored();
                }
                case 1: {
                    return StructureShrinkerTileEntity.this.energyStorage.getMaxEnergyStored();
                }
                case 2: {
                    return StructureShrinkerTileEntity.this.selectionStart.func_177958_n();
                }
                case 3: {
                    return StructureShrinkerTileEntity.this.selectionStart.func_177956_o();
                }
                case 4: {
                    return StructureShrinkerTileEntity.this.selectionStart.func_177952_p();
                }
                case 5: {
                    return StructureShrinkerTileEntity.this.selectionEnd.func_177958_n();
                }
                case 6: {
                    return StructureShrinkerTileEntity.this.selectionEnd.func_177956_o();
                }
                case 7: {
                    return StructureShrinkerTileEntity.this.selectionEnd.func_177952_p();
                }
            }
            return 0;
        }

        public void func_221477_a(int i, int value) {
            switch (i) {
                case 0: {
                    StructureShrinkerTileEntity.this.energyStorage.setEnergyStored(value);
                }
                case 1: {
                    StructureShrinkerTileEntity.this.energyStorage.setMaxEnergyStored(value);
                }
                case 2: {
                    StructureShrinkerTileEntity.this.selectionStart = new BlockPos(value, StructureShrinkerTileEntity.this.selectionStart.func_177956_o(), StructureShrinkerTileEntity.this.selectionStart.func_177952_p());
                }
                case 3: {
                    StructureShrinkerTileEntity.this.selectionStart = new BlockPos(StructureShrinkerTileEntity.this.selectionStart.func_177958_n(), value, StructureShrinkerTileEntity.this.selectionStart.func_177952_p());
                }
                case 4: {
                    StructureShrinkerTileEntity.this.selectionStart = new BlockPos(StructureShrinkerTileEntity.this.selectionStart.func_177958_n(), StructureShrinkerTileEntity.this.selectionStart.func_177956_o(), value);
                }
                case 5: {
                    StructureShrinkerTileEntity.this.selectionEnd = new BlockPos(value, StructureShrinkerTileEntity.this.selectionEnd.func_177956_o(), StructureShrinkerTileEntity.this.selectionEnd.func_177952_p());
                }
                case 6: {
                    StructureShrinkerTileEntity.this.selectionEnd = new BlockPos(StructureShrinkerTileEntity.this.selectionEnd.func_177958_n(), value, StructureShrinkerTileEntity.this.selectionEnd.func_177952_p());
                }
                case 7: {
                    StructureShrinkerTileEntity.this.selectionEnd = new BlockPos(StructureShrinkerTileEntity.this.selectionEnd.func_177958_n(), StructureShrinkerTileEntity.this.selectionEnd.func_177956_o(), value);
                }
            }
        }

        public int func_221478_a() {
            return 8;
        }
    };
    public FluidTankExt fluidTank = new FluidTankExt(5000, fluidStack -> fluidStack.getFluid().func_207187_a(PTFluids.SHRINK_PYM_PARTICLES)){}.setCallback(f -> {
        if (this.func_145831_w() != null) {
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        }
    }).setSoundHandler(sound -> {
        if (sound != null) {
            PlayerUtil.playSoundToAll((World)this.field_145850_b, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)50.0, (SoundEvent)sound, (SoundCategory)SoundCategory.BLOCKS);
        }
    });
    private ItemStackHandler energySlot = new ItemStackHandlerExt(1).setValidator((handler, slot, stack) -> stack.getCapability(CapabilityEnergy.ENERGY).isPresent()).setChangedCallback((handler, slot) -> this.func_70296_d());
    private ItemStackHandlerExt fluidSlots = new ItemStackHandlerExt(4){

        public int getSlotLimit(int slot) {
            return 1;
        }
    }.setChangedCallback((handler, slot) -> {
        if (slot == 0) {
            FluidActionResult res = TCFluidUtil.transferFluidFromItemToTank((ItemStack)handler.getStackInSlot(slot.intValue()), (IFluidHandler)this.fluidTank, (IItemHandler)handler, null);
            if (res.isSuccess()) {
                handler.setStackInSlot(slot.intValue(), res.getResult());
            }
        } else {
            FluidActionResult res = TCFluidUtil.transferFluidFromTankToItem((ItemStack)handler.getStackInSlot(slot.intValue()), (IFluidHandler)this.fluidTank, (IItemHandler)handler, null);
            if (res.isSuccess()) {
                handler.setStackInSlot(slot.intValue(), res.getResult());
            }
        }
        this.func_70296_d();
    }).setValidator((handler, slot, stack) -> FluidUtil.getFluidHandler((ItemStack)stack).isPresent());
    private CombinedInvWrapper combinedHandler = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.energySlot, this.fluidSlots});
    private LazyOptional<IItemHandlerModifiable> combinedInvLazyOptional = LazyOptional.of(() -> this.combinedHandler);
    private LazyOptional<IItemHandlerModifiable> energySlotLazyOptional = LazyOptional.of(() -> this.energySlot);
    private LazyOptional<IItemHandlerModifiable> fluidSlotLazyOptional = LazyOptional.of(() -> this.fluidSlots);
    private LazyOptional<IFluidHandler> fluidTankLazyOptional = LazyOptional.of(() -> this.fluidTank);

    public StructureShrinkerTileEntity() {
        super((TileEntityType)PTBlocks.STRUCTURE_SHRINKER_TILE_ENTITY.get());
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent(Util.func_200697_a((String)"container", (ResourceLocation)((TileEntityType)PTBlocks.STRUCTURE_SHRINKER_TILE_ENTITY.get()).getRegistryName()), new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new StructureShrinkerContainer(id, player, this, this.intArray);
    }

    public IItemHandler getEnergyInputSlots() {
        return this.energySlot;
    }

    public IEnergyConfig getEnergyConfig() {
        return PTServerConfig.STRUCTURE_SHRINKER_ENERGY;
    }

    public AxisAlignedBB getSelectionRelative() {
        return new AxisAlignedBB(this.selectionStart, this.selectionEnd);
    }

    public AxisAlignedBB getSelection() {
        BlockPos p1 = this.selectionStart.func_177971_a((Vec3i)this.func_174877_v());
        BlockPos p2 = this.selectionEnd.func_177971_a((Vec3i)this.func_174877_v());
        return new AxisAlignedBB(p1, p2);
    }

    public void setSelectionStart(BlockPos selectionStart) {
        this.selectionStart = selectionStart.func_177973_b((Vec3i)this.func_174877_v());
        if (this.func_145831_w() != null) {
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public void setSelectionEnd(BlockPos selectionEnd) {
        this.selectionEnd = selectionEnd.func_177973_b((Vec3i)this.func_174877_v());
        if (this.func_145831_w() != null) {
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public void shrink(@Nullable PlayerEntity activator) {
        if (this.func_145831_w() == null || this.func_145831_w().field_72995_K) {
            return;
        }
        PlayerEntity player = activator != null ? activator : new FakePlayer((ServerWorld)this.func_145831_w(), new GameProfile(null, "pymtech"));
        AxisAlignedBB box = this.getSelection();
        box = new AxisAlignedBB(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d + 1.0, box.field_72337_e + 1.0, box.field_72334_f + 1.0);
        if (!box.func_186662_g(1.0).func_72326_a(new AxisAlignedBB(this.func_174877_v()))) {
            player.func_146105_b(new TranslationTextComponent("pymtech.structure_shrinker.not_connected", new Object[0]).func_211708_a(TextFormatting.RED), true);
            return;
        }
        int count = BlockUtil.countBlocks(this.func_145831_w(), box);
        int energy = count * (Integer)PTServerConfig.STRUCTURE_SHRINKER_ENERGY_PER_BLOCK.get();
        int particles = (Integer)PTServerConfig.STRUCTURE_SHRINKER_PARTICLE_AMOUNT.get();
        if (count == 0) {
            player.func_146105_b(new TranslationTextComponent("pymtech.structure_shrinker.empty_structure", new Object[0]).func_211708_a(TextFormatting.RED), true);
            return;
        }
        if (this.energyStorage.getEnergyStored() < energy) {
            player.func_146105_b(new TranslationTextComponent("pymtech.structure_shrinker.not_enough_energy", new Object[]{energy}).func_211708_a(TextFormatting.RED), true);
            return;
        }
        if (this.fluidTank.drain(particles, IFluidHandler.FluidAction.SIMULATE).getAmount() < particles) {
            player.func_146105_b(new TranslationTextComponent("pymtech.structure_shrinker.not_enough_particles", new Object[]{particles}).func_211708_a(TextFormatting.RED), true);
            return;
        }
        this.energyStorage.setEnergyStored(this.energyStorage.getEnergyStored() - energy);
        this.fluidTank.drain(particles, IFluidHandler.FluidAction.EXECUTE);
        ShrunkenStructureData data = ShrunkenStructureData.create(ShrunkenStructureIdTracker.getNextId(this.func_145831_w()), this.func_145831_w(), box, p -> !MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(this.field_145850_b, p, this.field_145850_b.func_180495_p(p), player)) && this.field_145850_b.func_180495_p(p).func_185887_b((IBlockReader)this.field_145850_b, p) != -1.0f, true);
        ShrunkenStructureData.register(this.field_145850_b, data);
        ItemStack stack = ShrunkenStructureItem.create(data);
        ShrunkenStructureEntity entity = new ShrunkenStructureEntity(this.field_145850_b, box.func_189972_c().field_72450_a, box.field_72338_b, box.func_189972_c().field_72449_c, stack);
        entity.getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(sizeChanging -> {
            sizeChanging.startSizeChange(PTSizeChangeTypes.PYM_PARTICLES, 0.1f);
            sizeChanging.updateBoundingBox();
        });
        this.field_145850_b.func_217376_c((Entity)entity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.energySlot.deserializeNBT(nbt.func_74775_l("EnergySlots"));
        this.fluidSlots.deserializeNBT(nbt.func_74775_l("FluidSlots"));
        this.fluidTank.readFromNBT(nbt.func_74775_l("FluidTank"));
        this.selectionStart = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("SelectionStart"));
        this.selectionEnd = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("SelectionEnd"));
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_218657_a("EnergySlots", (INBT)this.energySlot.serializeNBT());
        nbt.func_218657_a("FluidSlots", (INBT)this.fluidSlots.serializeNBT());
        nbt.func_218657_a("FluidTank", (INBT)this.fluidTank.writeToNBT(new CompoundNBT()));
        nbt.func_218657_a("SelectionStart", (INBT)NBTUtil.func_186859_a((BlockPos)this.selectionStart));
        nbt.func_218657_a("SelectionEnd", (INBT)NBTUtil.func_186859_a((BlockPos)this.selectionEnd));
        return super.func_189515_b(nbt);
    }

    public void handleUpdateTag(CompoundNBT tag) {
        this.fluidTank.readFromNBT(tag.func_74775_l("FluidTank"));
        this.selectionStart = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("SelectionStart"));
        this.selectionEnd = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("SelectionEnd"));
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_218657_a("FluidTank", (INBT)this.fluidTank.writeToNBT(new CompoundNBT()));
        nbt.func_218657_a("SelectionStart", (INBT)NBTUtil.func_186859_a((BlockPos)this.selectionStart));
        nbt.func_218657_a("SelectionEnd", (INBT)NBTUtil.func_186859_a((BlockPos)this.selectionEnd));
        return nbt;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public boolean hasFastRenderer() {
        return true;
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.combinedInvLazyOptional.cast();
            }
            if (side == Direction.UP) {
                return this.energySlotLazyOptional.cast();
            }
            return this.fluidSlotLazyOptional.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidTankLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }
}

