/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore;

import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.command.CommandSource;
import net.minecraft.data.IDataProvider;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.threetag.threecore.ThreeCoreCommonConfig;
import net.threetag.threecore.ThreeCoreServerConfig;
import net.threetag.threecore.ability.AbilityClientEventHandler;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.ability.AbilityType;
import net.threetag.threecore.ability.IAbilityContainer;
import net.threetag.threecore.ability.condition.ConditionType;
import net.threetag.threecore.ability.superpower.SuperpowerManager;
import net.threetag.threecore.addonpacks.AddonPackManager;
import net.threetag.threecore.block.TCBlocks;
import net.threetag.threecore.capability.CapabilityAbilityContainer;
import net.threetag.threecore.capability.ThreeCoreCapabilities;
import net.threetag.threecore.client.renderer.AbilityBarRenderer;
import net.threetag.threecore.client.renderer.KarmaBarRenderer;
import net.threetag.threecore.client.renderer.UnconsciousRenderer;
import net.threetag.threecore.client.renderer.entity.model.EntityModelManager;
import net.threetag.threecore.client.renderer.entity.modellayer.ModelLayerLoader;
import net.threetag.threecore.command.ArmorStandPoseCommand;
import net.threetag.threecore.command.KarmaCommand;
import net.threetag.threecore.command.SizeChangeCommand;
import net.threetag.threecore.command.SuperpowerCommand;
import net.threetag.threecore.container.TCContainerTypes;
import net.threetag.threecore.data.ThreeCoreBlockTagsProvider;
import net.threetag.threecore.data.ThreeCoreEntityTypeTagsProvider;
import net.threetag.threecore.data.ThreeCoreItemTagsProvider;
import net.threetag.threecore.data.ThreeCoreRecipeProvider;
import net.threetag.threecore.data.lang.English;
import net.threetag.threecore.entity.TCEntityTypes;
import net.threetag.threecore.entity.armorstand.ArmorStandPoseManager;
import net.threetag.threecore.item.TCItems;
import net.threetag.threecore.item.recipe.TCRecipeSerializers;
import net.threetag.threecore.item.recipe.ToolIngredient;
import net.threetag.threecore.loot.function.TCLootFunctions;
import net.threetag.threecore.network.AbilityKeyMessage;
import net.threetag.threecore.network.AddAbilityMessage;
import net.threetag.threecore.network.BuyConditionMessage;
import net.threetag.threecore.network.KarmaInfoMessage;
import net.threetag.threecore.network.MultiJumpMessage;
import net.threetag.threecore.network.OpenConstructionTableTabMessage;
import net.threetag.threecore.network.RemoveAbilityMessage;
import net.threetag.threecore.network.SendArmorStandCommandMessage;
import net.threetag.threecore.network.SendPlayerAbilityContainerMessage;
import net.threetag.threecore.network.SendSuperpowerToastMessage;
import net.threetag.threecore.network.SetAbilityKeybindMessage;
import net.threetag.threecore.network.SetArmorStandPoseMessage;
import net.threetag.threecore.network.SyncKarmaMessage;
import net.threetag.threecore.network.SyncSizeMessage;
import net.threetag.threecore.network.SyncThreeDataMessage;
import net.threetag.threecore.network.UpdateAbilityMessage;
import net.threetag.threecore.network.UpdateSizeData;
import net.threetag.threecore.network.UpdateThreeDataMessage;
import net.threetag.threecore.potion.TCEffects;
import net.threetag.threecore.scripts.ScriptEventManager;
import net.threetag.threecore.scripts.accessors.ScriptAccessor;
import net.threetag.threecore.sound.TCSounds;
import net.threetag.threecore.tileentity.TCTileEntityTypes;
import net.threetag.threecore.util.RenderUtil;
import net.threetag.threecore.util.SupporterHandler;
import net.threetag.threecore.util.entityeffect.EntityEffectUpdateMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="threecore")
public class ThreeCore {
    public static final String MODID = "threecore";
    public static final Logger LOGGER = LogManager.getLogger();
    public static SimpleChannel NETWORK_CHANNEL;
    private static int networkId;
    public static final File MOD_SUBFOLDER;
    private static boolean htmlGenerated;

    public ThreeCore() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        SupporterHandler.load();
        this.registerMessages();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ThreeCoreCommonConfig.generateConfig());
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ThreeCoreServerConfig.generateConfig());
        AddonPackManager.init();
        TCLootFunctions.register();
        TCContainerTypes.registerConstructionTableTabls();
        AbilityHelper.registerAbilityContainer(CapabilityAbilityContainer.ID, p -> (IAbilityContainer)p.getCapability(CapabilityAbilityContainer.ABILITY_CONTAINER).orElse(null));
        for (EquipmentSlotType slots : EquipmentSlotType.values()) {
            AbilityHelper.registerAbilityContainer(new ResourceLocation(MODID, "item_" + slots.func_188450_d().toLowerCase()), p -> (IAbilityContainer)p.func_184582_a(slots).getCapability(CapabilityAbilityContainer.ABILITY_CONTAINER).orElse(null));
        }
        CraftingHelper.register((ResourceLocation)ToolIngredient.ID, (IIngredientSerializer)ToolIngredient.Serializer.INSTANCE);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            MinecraftForge.EVENT_BUS.addListener(RenderUtil::onRenderGlobal);
            MinecraftForge.EVENT_BUS.register((Object)new KarmaBarRenderer());
            MinecraftForge.EVENT_BUS.register((Object)new AbilityBarRenderer());
            MinecraftForge.EVENT_BUS.register((Object)new UnconsciousRenderer());
            MinecraftForge.EVENT_BUS.register((Object)new AbilityClientEventHandler());
            if (Minecraft.func_71410_x() != null) {
                ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)new EntityModelManager());
                ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)new ModelLayerLoader());
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void registries(RegistryEvent.NewRegistry e) {
        TCItems.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        TCBlocks.BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        TCTileEntityTypes.TILE_ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        TCContainerTypes.CONTAINER_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        TCRecipeSerializers.RECIPE_SERIALIZERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        TCEntityTypes.ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        TCSounds.SOUND_EVENTS.register(FMLJavaModLoadingContext.get().getModEventBus());
        TCEffects.EFFECTS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        TCBlocks.initOres();
        ThreeCoreCapabilities.init();
        TCItems.loadItemColors();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void setupClient(FMLClientSetupEvent e) {
        TCTileEntityTypes.initRenderers();
        TCEntityTypes.initRenderers();
        TCContainerTypes.initContainerScreens();
        ArmorStandPoseManager.init();
    }

    public void registerMessages() {
        ThreeCore.registerMessage(OpenConstructionTableTabMessage.class, OpenConstructionTableTabMessage::toBytes, OpenConstructionTableTabMessage::new, OpenConstructionTableTabMessage::handle);
        ThreeCore.registerMessage(SendPlayerAbilityContainerMessage.class, SendPlayerAbilityContainerMessage::toBytes, SendPlayerAbilityContainerMessage::new, SendPlayerAbilityContainerMessage::handle);
        ThreeCore.registerMessage(UpdateAbilityMessage.class, UpdateAbilityMessage::toBytes, UpdateAbilityMessage::new, UpdateAbilityMessage::handle);
        ThreeCore.registerMessage(AddAbilityMessage.class, AddAbilityMessage::toBytes, AddAbilityMessage::new, AddAbilityMessage::handle);
        ThreeCore.registerMessage(RemoveAbilityMessage.class, RemoveAbilityMessage::toBytes, RemoveAbilityMessage::new, RemoveAbilityMessage::handle);
        ThreeCore.registerMessage(AbilityKeyMessage.class, AbilityKeyMessage::toBytes, AbilityKeyMessage::new, AbilityKeyMessage::handle);
        ThreeCore.registerMessage(SendSuperpowerToastMessage.class, SendSuperpowerToastMessage::toBytes, SendSuperpowerToastMessage::new, SendSuperpowerToastMessage::handle);
        ThreeCore.registerMessage(BuyConditionMessage.class, BuyConditionMessage::toBytes, BuyConditionMessage::new, BuyConditionMessage::handle);
        ThreeCore.registerMessage(SetAbilityKeybindMessage.class, SetAbilityKeybindMessage::toBytes, SetAbilityKeybindMessage::new, SetAbilityKeybindMessage::handle);
        ThreeCore.registerMessage(MultiJumpMessage.class, MultiJumpMessage::toBytes, MultiJumpMessage::new, MultiJumpMessage::handle);
        ThreeCore.registerMessage(SyncKarmaMessage.class, SyncKarmaMessage::toBytes, SyncKarmaMessage::new, SyncKarmaMessage::handle);
        ThreeCore.registerMessage(KarmaInfoMessage.class, KarmaInfoMessage::toBytes, KarmaInfoMessage::new, KarmaInfoMessage::handle);
        ThreeCore.registerMessage(SyncSizeMessage.class, SyncSizeMessage::toBytes, SyncSizeMessage::new, SyncSizeMessage::handle);
        ThreeCore.registerMessage(UpdateSizeData.class, UpdateSizeData::toBytes, UpdateSizeData::new, UpdateSizeData::handle);
        ThreeCore.registerMessage(SetArmorStandPoseMessage.class, SetArmorStandPoseMessage::toBytes, SetArmorStandPoseMessage::new, SetArmorStandPoseMessage::handle);
        ThreeCore.registerMessage(SendArmorStandCommandMessage.class, SendArmorStandCommandMessage::toBytes, SendArmorStandCommandMessage::new, SendArmorStandCommandMessage::handle);
        ThreeCore.registerMessage(UpdateThreeDataMessage.class, UpdateThreeDataMessage::toBytes, UpdateThreeDataMessage::new, UpdateThreeDataMessage::handle);
        ThreeCore.registerMessage(SyncThreeDataMessage.class, SyncThreeDataMessage::toBytes, SyncThreeDataMessage::new, SyncThreeDataMessage::handle);
        ThreeCore.registerMessage(EntityEffectUpdateMessage.class, EntityEffectUpdateMessage::toBytes, EntityEffectUpdateMessage::new, EntityEffectUpdateMessage::handle);
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent e) {
        e.getGenerator().func_200390_a((IDataProvider)new ThreeCoreBlockTagsProvider(e.getGenerator()));
        e.getGenerator().func_200390_a((IDataProvider)new ThreeCoreItemTagsProvider(e.getGenerator()));
        e.getGenerator().func_200390_a((IDataProvider)new ThreeCoreEntityTypeTagsProvider(e.getGenerator()));
        e.getGenerator().func_200390_a((IDataProvider)new ThreeCoreRecipeProvider(e.getGenerator()));
        e.getGenerator().func_200390_a((IDataProvider)new English(e.getGenerator()));
    }

    @SubscribeEvent
    public void serverStarting(FMLServerStartingEvent e) {
        SuperpowerCommand.register((CommandDispatcher<CommandSource>)e.getCommandDispatcher());
        KarmaCommand.register((CommandDispatcher<CommandSource>)e.getCommandDispatcher());
        SizeChangeCommand.register((CommandDispatcher<CommandSource>)e.getCommandDispatcher());
        ArmorStandPoseCommand.register((CommandDispatcher<CommandSource>)e.getCommandDispatcher());
    }

    @SubscribeEvent
    public void serverAboutToStart(FMLServerAboutToStartEvent e) {
        e.getServer().func_195570_aG().func_219534_a((IFutureReloadListener)new SuperpowerManager());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void initGui(GuiScreenEvent.InitGuiEvent e) {
        if (e.getGui() instanceof MainMenuScreen && !htmlGenerated) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
                AbilityType.generateHtmlFile(new File(MOD_SUBFOLDER, "abilities.html"));
                ConditionType.generateHtmlFile(new File(MOD_SUBFOLDER, "conditions.html"));
                ScriptAccessor.generateHtmlFile(new File(MOD_SUBFOLDER, "script_accessors.html"));
                ScriptEventManager.generateHtmlFile(new File(MOD_SUBFOLDER, "script_events.html"));
            });
            htmlGenerated = true;
        }
    }

    public static <MSG> int registerMessage(Class<MSG> messageType, BiConsumer<MSG, PacketBuffer> encoder, Function<PacketBuffer, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer) {
        if (NETWORK_CHANNEL == null) {
            NETWORK_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, MODID), () -> "1.0", s -> true, s -> true);
        }
        int id = networkId++;
        NETWORK_CHANNEL.registerMessage(id, messageType, encoder, decoder, messageConsumer);
        return id;
    }

    static {
        networkId = -1;
        MOD_SUBFOLDER = new File("mods/threecore");
        htmlGenerated = false;
    }
}

