/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.ability.CustomHotbarAbility;
import net.threetag.threecore.ability.InvisibilityAbility;
import net.threetag.threecore.ability.MultiJumpAbility;
import net.threetag.threecore.client.gui.ability.AbilitiesScreen;
import net.threetag.threecore.client.gui.widget.TranslucentButton;
import net.threetag.threecore.client.renderer.AbilityBarRenderer;
import net.threetag.threecore.client.settings.AbilityKeyBinding;
import net.threetag.threecore.network.AbilityKeyMessage;
import net.threetag.threecore.network.MultiJumpMessage;

public class AbilityClientEventHandler {
    public static final String CATEGORY = "ThreeCore";
    public static final KeyBinding SCROLL_UP = new KeyBinding("key.threecore.scroll_up", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM, 73, "ThreeCore");
    public static final KeyBinding SCROLL_DOWN = new KeyBinding("key.threecore.scroll_down", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM, 80, "ThreeCore");
    public static List<AbilityKeyBinding> ABILITY_KEYS = Lists.newArrayList();
    public static Map<Integer, Boolean> KEY_STATE = Maps.newHashMap();

    public AbilityClientEventHandler() {
        if (Minecraft.func_71410_x() != null) {
            ClientRegistry.registerKeyBinding((KeyBinding)SCROLL_UP);
            ClientRegistry.registerKeyBinding((KeyBinding)SCROLL_DOWN);
            for (int i = 1; i <= 5; ++i) {
                AbilityKeyBinding keyBinding = new AbilityKeyBinding("key.threecore.ability_" + i, (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM, i == 1 ? 86 : (i == 2 ? 66 : (i == 3 ? 78 : (i == 4 ? 77 : (i == 5 ? 44 : -1)))), i, CATEGORY);
                ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
                ABILITY_KEYS.add(keyBinding);
            }
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent e) {
        if (Minecraft.func_71410_x().field_71439_g == null || Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        if (e.getAction() < 2) {
            List<Object> abilities = AbilityHelper.getAbilities((LivingEntity)Minecraft.func_71410_x().field_71439_g).stream().filter(a -> a.getConditionManager().isUnlocked() && a.getConditionManager().needsKey() && a.getDataManager().get(Ability.KEYBIND) > -1).collect(Collectors.toList());
            for (Ability ability : abilities) {
                if (ability == null || ability.getContainer() == null || ability.getDataManager().get(Ability.KEYBIND).intValue() != e.getKey()) continue;
                if (!KEY_STATE.containsKey(e.getKey())) {
                    KEY_STATE.put(e.getKey(), false);
                }
                if (KEY_STATE.get(e.getKey()) != (e.getAction() == 1)) {
                    ThreeCore.NETWORK_CHANNEL.sendToServer((Object)new AbilityKeyMessage(ability.getContainer().getId(), ability.getId(), e.getAction() == 1));
                }
                KEY_STATE.put(e.getKey(), e.getAction() == 1);
            }
            abilities = AbilityBarRenderer.getCurrentDisplayedAbilities(AbilityHelper.getAbilities((LivingEntity)Minecraft.func_71410_x().field_71439_g));
            for (AbilityKeyBinding abilityKeyBinding : ABILITY_KEYS) {
                Ability ability;
                if (e.getKey() != abilityKeyBinding.getKey().func_197937_c()) continue;
                if (!KEY_STATE.containsKey(e.getKey())) {
                    KEY_STATE.put(e.getKey(), false);
                }
                if (abilityKeyBinding.index > abilities.size() || (ability = (Ability)abilities.get(abilityKeyBinding.index - 1)) == null || ability.getContainer() == null || KEY_STATE.get(e.getKey()) == (e.getAction() == 1)) continue;
                ThreeCore.NETWORK_CHANNEL.sendToServer((Object)new AbilityKeyMessage(ability.getContainer().getId(), ability.getId(), e.getAction() == 1));
                KEY_STATE.put(e.getKey(), e.getAction() == 1);
            }
        }
        if (SCROLL_UP.func_151470_d()) {
            AbilityBarRenderer.scroll(true);
        } else if (SCROLL_DOWN.func_151470_d()) {
            AbilityBarRenderer.scroll(false);
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d() && !Minecraft.func_71410_x().field_71439_g.field_70122_E) {
            for (MultiJumpAbility ability : AbilityHelper.getAbilitiesFromClass((LivingEntity)Minecraft.func_71410_x().field_71439_g, MultiJumpAbility.class)) {
                if (!ability.getConditionManager().isEnabled()) continue;
                ThreeCore.NETWORK_CHANNEL.sendToServer((Object)new MultiJumpMessage(ability.container.getId(), ability.getId()));
            }
        }
    }

    @SubscribeEvent
    public void onMouse(GuiScreenEvent.MouseScrollEvent.Pre e) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g.func_70093_af() && e.getScrollDelta() != 0.0) {
            AbilityBarRenderer.scroll(e.getScrollDelta() > 0.0);
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent e) {
        if (e.getGui() instanceof ChatScreen) {
            e.addWidget((Widget)new TranslucentButton(e.getGui().width - 1 - 75, e.getGui().height - 40, 75, 20, I18n.func_135052_a((String)"gui.threecore.abilities", (Object[])new Object[0]), b -> Minecraft.func_71410_x().func_147108_a((Screen)new AbilitiesScreen())));
        }
        for (Integer i : KEY_STATE.keySet()) {
            KEY_STATE.put(i, false);
        }
    }

    @SubscribeEvent
    public void onRenderLivingPre(RenderLivingEvent.Pre e) {
        for (InvisibilityAbility invisibilityAbility : AbilityHelper.getAbilitiesFromClass(e.getEntity(), InvisibilityAbility.class)) {
            if (!invisibilityAbility.getConditionManager().isEnabled()) continue;
            e.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onHeartsPre(RenderGameOverlayEvent.Pre e) {
        for (CustomHotbarAbility ability : AbilityHelper.getAbilitiesFromClass((LivingEntity)Minecraft.func_71410_x().field_71439_g, CustomHotbarAbility.class)) {
            if (!ability.getConditionManager().isEnabled() || e.getType() != ability.getDataManager().get(CustomHotbarAbility.HOTBAR_ELEMENT)) continue;
            AbstractGui.GUI_ICONS_LOCATION = ability.getDataManager().get(CustomHotbarAbility.TEXTURE);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(AbstractGui.GUI_ICONS_LOCATION);
        }
    }

    @SubscribeEvent
    public void onHeartsPost(RenderGameOverlayEvent.Post e) {
        for (CustomHotbarAbility ability : AbilityHelper.getAbilitiesFromClass((LivingEntity)Minecraft.func_71410_x().field_71439_g, CustomHotbarAbility.class)) {
            if (!ability.getConditionManager().isEnabled() || e.getType() != ability.getDataManager().get(CustomHotbarAbility.HOTBAR_ELEMENT)) continue;
            AbstractGui.GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");
            Minecraft.func_71410_x().func_110434_K().func_110577_a(AbstractGui.GUI_ICONS_LOCATION);
        }
    }
}

