/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityGenerator;
import net.threetag.threecore.ability.AbilityMap;
import net.threetag.threecore.ability.AbilityType;
import net.threetag.threecore.ability.IAbilityContainer;
import net.threetag.threecore.ability.condition.AbilityUnlockedCondition;
import net.threetag.threecore.ability.condition.Condition;

public class AbilityHelper {
    private static final Map<ResourceLocation, Function<LivingEntity, IAbilityContainer>> REGISTRY = Maps.newHashMap();

    public static Function<LivingEntity, IAbilityContainer> registerAbilityContainer(ResourceLocation name, Function<LivingEntity, IAbilityContainer> containerSupplier) {
        if (REGISTRY.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate ability supplier " + name.toString());
        }
        REGISTRY.put(name, containerSupplier);
        return containerSupplier;
    }

    public static IAbilityContainer getAbilityContainerFromId(LivingEntity entity, ResourceLocation id) {
        Function<LivingEntity, IAbilityContainer> function = REGISTRY.get(id);
        if (function != null) {
            return function.apply(entity);
        }
        return null;
    }

    public static Collection<Function<LivingEntity, IAbilityContainer>> getAbilityContainerList() {
        return REGISTRY.values();
    }

    public static List<Ability> getAbilities(LivingEntity entity) {
        ArrayList<Ability> list = new ArrayList<Ability>();
        AbilityHelper.getAbilityContainerList().forEach(f -> {
            IAbilityContainer container = (IAbilityContainer)f.apply(entity);
            if (container != null) {
                list.addAll(container.getAbilities());
            }
        });
        return list;
    }

    public static Ability getAbilityById(LivingEntity entity, String id, @Nullable IAbilityContainer currentContainer) {
        String[] strings = id.split("#", 2);
        if (strings.length == 1 && currentContainer == null) {
            return null;
        }
        if (strings.length == 1) {
            return currentContainer.getAbility(strings[0]);
        }
        IAbilityContainer container = AbilityHelper.getAbilityContainerFromId(entity, new ResourceLocation(strings[0]));
        return container.getAbility(strings[1]);
    }

    public static <T extends Ability> List<T> getAbilitiesFromClass(LivingEntity entity, Class<T> abilityClass) {
        return AbilityHelper.getAbilitiesFromClass(AbilityHelper.getAbilities(entity), abilityClass);
    }

    public static <T extends Ability> List<T> getAbilitiesFromClass(List<Ability> list, Class<T> abilityClass) {
        LinkedList<Ability> abilities = new LinkedList<Ability>();
        for (Ability ab : list) {
            if (ab.getClass() != abilityClass) continue;
            abilities.add(ab);
        }
        return abilities;
    }

    public static List<Ability> findChildrenAbilities(LivingEntity entity, Ability ability, IAbilityContainer container) {
        LinkedList list = Lists.newLinkedList();
        for (Ability all : container.getAbilities()) {
            for (Condition condition : all.getConditionManager().getConditions()) {
                Ability a;
                if (!(condition instanceof AbilityUnlockedCondition) || condition.getDataManager().get(Condition.ENABLING).booleanValue() || (a = AbilityHelper.getAbilityById(entity, condition.getDataManager().get(AbilityUnlockedCondition.ABILITY_ID), ability.container)) != ability) continue;
                list.add(all);
            }
        }
        return list;
    }

    public static List<Ability> findParentAbilities(LivingEntity entity, Ability ability, IAbilityContainer container) {
        LinkedList list = Lists.newLinkedList();
        for (Condition condition : ability.getConditionManager().getConditions()) {
            Ability a;
            if (!(condition instanceof AbilityUnlockedCondition) || condition.getDataManager().get(Condition.ENABLING).booleanValue() || (a = AbilityHelper.getAbilityById(entity, condition.getDataManager().get(AbilityUnlockedCondition.ABILITY_ID), ability.container)) == null) continue;
            list.add(a);
        }
        return list;
    }

    public static CompoundNBT saveToNBT(AbilityMap map, boolean network) {
        CompoundNBT nbt = new CompoundNBT();
        map.forEach((s, a) -> nbt.func_218657_a(s, (INBT)(network ? a.getUpdateTag() : a.serializeNBT())));
        return nbt;
    }

    public static CompoundNBT saveToNBT(AbilityMap map) {
        return AbilityHelper.saveToNBT(map, false);
    }

    public static AbilityMap loadFromNBT(CompoundNBT nbt, AbilityMap map, boolean network) {
        nbt.func_150296_c().forEach(s -> {
            CompoundNBT tag = nbt.func_74775_l(s);
            AbilityType abilityType = (AbilityType)AbilityType.REGISTRY.getValue(new ResourceLocation(tag.func_74779_i("AbilityType")));
            if (abilityType != null) {
                Ability ability = abilityType.create();
                if (network) {
                    ability.readUpdateTag(tag);
                } else {
                    ability.deserializeNBT(tag);
                }
                map.put((String)s, ability);
            } else {
                ThreeCore.LOGGER.error("Ability type " + tag.func_74779_i("AbilityType") + " does not exist!");
            }
        });
        return map;
    }

    public static AbilityMap loadFromNBT(CompoundNBT nbt, AbilityMap map) {
        return AbilityHelper.loadFromNBT(nbt, map, false);
    }

    public static List<AbilityGenerator> parseAbilityGenerators(JsonObject jsonObject, boolean useId) {
        ArrayList abilityGenerators = Lists.newArrayList();
        jsonObject.entrySet().forEach(e -> {
            if (e.getValue() instanceof JsonObject) {
                JsonObject o = (JsonObject)e.getValue();
                if (useId) {
                    abilityGenerators.add(new AbilityGenerator((String)e.getKey(), new ResourceLocation(JSONUtils.func_151200_h((JsonObject)o, (String)"ability")), o));
                } else {
                    AbilityType type = (AbilityType)AbilityType.REGISTRY.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)o, (String)"ability")));
                    if (type == null) {
                        throw new JsonSyntaxException("Expected 'ability' to be an ability, was unknown string '" + JSONUtils.func_151200_h((JsonObject)o, (String)"ability") + "'");
                    }
                    abilityGenerators.add(new AbilityGenerator((String)e.getKey(), type, o));
                }
            }
        });
        return abilityGenerators;
    }

    public static List<AbilityGenerator> parseAbilityGenerators(JsonObject jsonObject) {
        return AbilityHelper.parseAbilityGenerators(jsonObject, false);
    }
}

