/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability;

import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityType;
import net.threetag.threecore.ability.FlightAbility;
import net.threetag.threecore.sound.FlightSound;
import net.threetag.threecore.util.icon.TexturedIcon;
import net.threetag.threecore.util.threedata.EnumSync;
import net.threetag.threecore.util.threedata.FloatThreeData;
import net.threetag.threecore.util.threedata.ThreeData;

public class AcceleratingFlightAbility
extends Ability
implements FlightSound.IFlyingAbility {
    public static final ThreeData<Float> BASE_SPEED = new FloatThreeData("base_speed").setSyncType(EnumSync.NONE).enableSetting("Speed you start with when starting to fly");
    public static final ThreeData<Float> MAX_SPEED = new FloatThreeData("max_speed").setSyncType(EnumSync.NONE).enableSetting("Maximum flight speed you can reach");
    public static final ThreeData<Float> ACCELERATION = new FloatThreeData("acceleration").setSyncType(EnumSync.NONE).enableSetting("Acceleration: amount of speed per tick");
    public float speed;
    public Object sound;

    public AcceleratingFlightAbility() {
        super(AbilityType.ACCELERATING_FLIGHT);
    }

    @Override
    public void registerData() {
        super.registerData();
        this.register(ICON, new TexturedIcon(TexturedIcon.ICONS_TEXTURE, 0, 16, 16, 16));
        this.register(BASE_SPEED, Float.valueOf(0.25f));
        this.register(MAX_SPEED, Float.valueOf(10.0f));
        this.register(ACCELERATION, Float.valueOf(0.01f));
        this.register(FlightAbility.ROTATE_ARMS, true);
    }

    @Override
    public void firstTick(final LivingEntity entity) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

            @Override
            public void run() {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new FlightSound(AcceleratingFlightAbility.this, entity, SoundEvents.field_189426_aK, SoundCategory.PLAYERS));
            }
        });
    }

    @Override
    public void action(LivingEntity entity) {
        if (!entity.field_70122_E) {
            if (entity.field_191988_bg > 0.0f) {
                this.startSound(entity);
                Vec3d vec = entity.func_70040_Z();
                this.speed = MathHelper.func_76131_a((float)(this.speed + ((Float)this.get(ACCELERATION)).floatValue()), (float)((Float)this.get(BASE_SPEED)).floatValue(), (float)((Float)this.get(MAX_SPEED)).floatValue());
                entity.func_213293_j(vec.field_72450_a * (double)this.speed, vec.field_72448_b * (double)this.speed - (double)(entity.func_70093_af() ? entity.func_213302_cg() * 0.2f : 0.0f), vec.field_72449_c * (double)this.speed);
            } else {
                this.speed = entity.func_213322_ci().func_72433_c() <= 1.0 ? 0.0f : MathHelper.func_76131_a((float)(this.speed - ((Float)this.get(ACCELERATION)).floatValue()), (float)((Float)this.get(BASE_SPEED)).floatValue(), (float)((Float)this.get(MAX_SPEED)).floatValue());
                if (entity.func_70093_af()) {
                    entity.func_213317_d(new Vec3d(entity.func_213322_ci().field_72450_a, (double)(entity.func_213302_cg() * -0.2f), entity.func_213322_ci().field_72449_c));
                } else {
                    entity.func_213317_d(new Vec3d(entity.func_213322_ci().field_72450_a, Math.sin((float)entity.field_70173_aa / 10.0f) / 100.0, entity.func_213322_ci().field_72449_c));
                }
            }
        } else {
            this.speed = 0.0f;
        }
    }

    public void startSound(final LivingEntity entity) {
        if (this.sound == null) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                @Override
                public void run() {
                    AcceleratingFlightAbility.this.sound = new FlightSound(AcceleratingFlightAbility.this, entity, SoundEvents.field_189426_aK, SoundCategory.PLAYERS);
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)AcceleratingFlightAbility.this.sound);
                }
            });
        }
    }

    @Override
    public void onFinishedPlayingSound() {
        this.sound = null;
    }
}

