/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityPropertiesPacket;
import net.minecraft.util.text.ITextComponent;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityType;
import net.threetag.threecore.entity.attributes.AttributeRegistry;
import net.threetag.threecore.util.icon.IIcon;
import net.threetag.threecore.util.threedata.AttributeOperationThreeData;
import net.threetag.threecore.util.threedata.AttributeThreeData;
import net.threetag.threecore.util.threedata.EnumSync;
import net.threetag.threecore.util.threedata.FloatThreeData;
import net.threetag.threecore.util.threedata.ThreeData;
import net.threetag.threecore.util.threedata.UUIDThreeData;

public class AttributeModifierAbility
extends Ability {
    public static final Map<String, IAttribute> ATTRIBUTES = Maps.newHashMap();
    public static final ThreeData<IAttribute> ATTRIBUTE = new AttributeThreeData("attribute").setSyncType(EnumSync.SELF).enableSetting("attribute", "Determines which attribute should be modified. Possible attribute: " + AttributeModifierAbility.getAttributeList());
    public static final ThreeData<Float> AMOUNT = new FloatThreeData("amount").setSyncType(EnumSync.SELF).enableSetting("amount", "The amount for the giving attribute modifier");
    public static final ThreeData<AttributeModifier.Operation> OPERATION = new AttributeOperationThreeData("operation").setSyncType(EnumSync.SELF).enableSetting("operation", "The operation for the giving attribute modifier (More: https://minecraft.gamepedia.com/Attribute#Operations)");
    public static final ThreeData<UUID> UUID = new UUIDThreeData("uuid").setSyncType(EnumSync.SELF).enableSetting("uuid", "Sets the unique identifier for this attribute modifier. If not specified it will generate a random one");

    public AttributeModifierAbility() {
        super(AbilityType.ATTRIBUTE_MODIFIER);
    }

    @Override
    public void registerData() {
        super.registerData();
        this.dataManager.register((ThreeData)ATTRIBUTE, ((AttributeRegistry.AttributeEntry)AttributeRegistry.REGISTRY.func_186801_a(new Random())).getAttribute());
        this.dataManager.register((ThreeData)AMOUNT, Float.valueOf(1.0f));
        this.dataManager.register((ThreeData)OPERATION, AttributeModifier.Operation.ADDITION);
        this.dataManager.register((ThreeData)UUID, java.util.UUID.fromString("498be4fb-af04-42f2-8948-e6ccdc0d99e1"));
    }

    @Override
    public void readFromJson(JsonObject jsonObject) {
        super.readFromJson(jsonObject);
        IIcon icon = AttributeRegistry.getEntry(this.dataManager.get(ATTRIBUTE)).makeIcon();
        if (icon != null) {
            this.dataManager.register(ICON, icon);
        }
    }

    @Override
    public void action(LivingEntity entity) {
        Collection set;
        IAttribute attribute = this.dataManager.get(ATTRIBUTE);
        if (entity.func_110140_aT().func_111151_a(attribute) == null || entity.field_70170_p.field_72995_K) {
            return;
        }
        UUID uuid = this.dataManager.get(UUID);
        if (entity.func_110140_aT().func_111146_a().stream().noneMatch(iAttributeInstance -> iAttributeInstance.func_111123_a() == attribute)) {
            entity.func_110140_aT().func_111150_b(attribute).func_111128_a(attribute.func_111110_b());
        }
        if (entity.func_110140_aT().func_111151_a(attribute).func_111127_a(uuid) != null && (entity.func_110148_a(attribute).func_111127_a(uuid).func_111164_d() != (double)this.dataManager.get(AMOUNT).floatValue() || entity.func_110148_a(attribute).func_111127_a(uuid).func_220375_c() != this.dataManager.get(OPERATION))) {
            entity.func_110140_aT().func_111151_a(attribute).func_188479_b(uuid);
        }
        if (entity.func_110140_aT().func_111151_a(attribute).func_111127_a(uuid) == null) {
            AttributeModifier modifier = new AttributeModifier(uuid, ((ITextComponent)this.dataManager.get(TITLE)).func_150254_d(), (double)this.dataManager.get(AMOUNT).floatValue(), this.dataManager.get(OPERATION)).func_111168_a(false);
            entity.func_110140_aT().func_111151_a(attribute).func_111121_a(modifier);
        }
        if (entity.field_70173_aa < 20 && entity instanceof ServerPlayerEntity && !(set = entity.func_110140_aT().func_111146_a()).isEmpty()) {
            ((ServerPlayerEntity)entity).field_71135_a.func_147359_a((IPacket)new SEntityPropertiesPacket(entity.func_145782_y(), set));
        }
    }

    @Override
    public void lastTick(LivingEntity entity) {
        if (entity.func_110140_aT().func_111151_a(this.dataManager.get(ATTRIBUTE)) != null && entity.func_110140_aT().func_111151_a(this.dataManager.get(ATTRIBUTE)).func_111127_a(this.dataManager.get(UUID)) != null) {
            entity.func_110140_aT().func_111151_a(this.dataManager.get(ATTRIBUTE)).func_188479_b(this.dataManager.get(UUID));
        }
    }

    private static String getAttributeList() {
        String s = "";
        Iterator iterator = AttributeRegistry.REGISTRY.iterator();
        while (iterator.hasNext()) {
            s = s + ", \"" + AttributeRegistry.REGISTRY.func_177774_c(iterator.next()).toString() + "\"";
        }
        return s.substring(2);
    }
}

