/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability;

import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityType;
import net.threetag.threecore.sound.FlightSound;
import net.threetag.threecore.util.icon.TexturedIcon;
import net.threetag.threecore.util.threedata.BooleanThreeData;
import net.threetag.threecore.util.threedata.EnumSync;
import net.threetag.threecore.util.threedata.FloatThreeData;
import net.threetag.threecore.util.threedata.ThreeData;

public class FlightAbility
extends Ability
implements FlightSound.IFlyingAbility {
    public static final ThreeData<Float> SPEED = new FloatThreeData("speed").setSyncType(EnumSync.SELF).enableSetting("speed", "Sets the speed multiplier for flying when you are NOT sprinting");
    public static final ThreeData<Float> SPRINT_SPEED = new FloatThreeData("sprint_speed").setSyncType(EnumSync.SELF).enableSetting("sprint_speed", "Sets the speed multiplier for flying when you are sprinting");
    public static final ThreeData<Boolean> ROTATE_ARMS = new BooleanThreeData("rotate_arms").enableSetting("rotate_arms", "If enabled the players arms will face in your direction (like Superman)");
    public Object sound;

    public FlightAbility() {
        super(AbilityType.FLIGHT);
    }

    @Override
    public void registerData() {
        super.registerData();
        this.dataManager.register(ICON, new TexturedIcon(TexturedIcon.ICONS_TEXTURE, 0, 16, 16, 16));
        this.dataManager.register((ThreeData)SPEED, Float.valueOf(1.0f));
        this.dataManager.register((ThreeData)SPRINT_SPEED, Float.valueOf(3.0f));
        this.dataManager.register((ThreeData)ROTATE_ARMS, (Object)true);
    }

    @Override
    public void action(LivingEntity entity) {
        if (!entity.field_70122_E) {
            if (entity.field_191988_bg > 0.0f) {
                this.startSound(entity);
                Vec3d vec = entity.func_70040_Z();
                double speed = entity.func_70051_ag() ? (double)this.dataManager.get(SPRINT_SPEED).floatValue() : (double)this.dataManager.get(SPEED).floatValue();
                entity.func_213293_j(vec.field_72450_a * speed, vec.field_72448_b * speed - (double)(entity.func_70093_af() ? entity.func_213302_cg() * 0.2f : 0.0f), vec.field_72449_c * speed);
            } else if (entity.func_70093_af()) {
                entity.func_213317_d(new Vec3d(entity.func_213322_ci().field_72450_a, (double)(entity.func_213302_cg() * -0.2f), entity.func_213322_ci().field_72449_c));
            } else {
                entity.func_213317_d(new Vec3d(entity.func_213322_ci().field_72450_a, Math.sin((float)entity.field_70173_aa / 10.0f) / 100.0, entity.func_213322_ci().field_72449_c));
            }
        }
    }

    public void startSound(LivingEntity entity) {
        if (this.sound == null) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
                this.sound = new FlightSound(this, entity, SoundEvents.field_189426_aK, SoundCategory.PLAYERS);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.sound);
            });
        }
    }

    @Override
    public void onFinishedPlayingSound() {
        this.sound = null;
    }
}

