/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability.condition;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.ability.condition.Condition;
import net.threetag.threecore.ability.condition.ConditionType;
import net.threetag.threecore.util.threedata.EnumSync;
import net.threetag.threecore.util.threedata.StringThreeData;
import net.threetag.threecore.util.threedata.TextComponentThreeData;
import net.threetag.threecore.util.threedata.ThreeData;

public class AbilityUnlockedCondition
extends Condition {
    public static final ThreeData<String> ABILITY_ID = new StringThreeData("ability_id").setSyncType(EnumSync.SELF).enableSetting("ability_id", "The id for the ability that must be unlocked for the condition to be true.");
    public static final ThreeData<ITextComponent> ABILITY_TITLE = new TextComponentThreeData("ability_title").setSyncType(EnumSync.SELF);

    public AbilityUnlockedCondition(Ability ability) {
        super(ConditionType.ABILITY_UNLOCKED, ability);
    }

    @Override
    public void registerData() {
        super.registerData();
        this.dataManager.register((ThreeData)ABILITY_ID, "");
        this.dataManager.register((ThreeData)ABILITY_TITLE, new StringTextComponent("/"));
    }

    @Override
    public ITextComponent createTitle() {
        return new TranslationTextComponent(Util.func_200697_a((String)"ability.condition", (ResourceLocation)this.type.getRegistryName()) + ((Boolean)this.dataManager.get(INVERT) != false ? ".not" : ""), new Object[]{this.dataManager.get(ABILITY_TITLE)});
    }

    @Override
    public boolean test(LivingEntity entity) {
        Ability dependentAbility = AbilityHelper.getAbilityById(entity, this.dataManager.get(ABILITY_ID), this.ability.container);
        return dependentAbility != null && dependentAbility != this.ability && dependentAbility.getConditionManager().isUnlocked();
    }
}

