/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability.condition;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.Tags;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.condition.Condition;
import net.threetag.threecore.ability.condition.ConditionType;
import net.threetag.threecore.util.threedata.BooleanThreeData;
import net.threetag.threecore.util.threedata.EnumSync;
import net.threetag.threecore.util.threedata.ItemTagThreeData;
import net.threetag.threecore.util.threedata.ThreeData;

public class WearingItemTagCondition
extends Condition {
    public static final ThreeData<Tag<Item>> ITEM_TAG = new ItemTagThreeData("item_tag").setSyncType(EnumSync.SELF).enableSetting("Determines the item tag the items must have");
    public static final Map<EquipmentSlotType, ThreeData<Boolean>> SLOT_DATA = Maps.newHashMap();

    public WearingItemTagCondition(Ability ability) {
        super(ConditionType.WEARING_ITEM_TAG, ability);
    }

    @Override
    public ITextComponent createTitle() {
        return new TranslationTextComponent(Util.func_200697_a((String)"ability.condition", (ResourceLocation)this.type.getRegistryName()) + ((Boolean)this.dataManager.get(INVERT) != false ? ".not" : ""), new Object[]{this.dataManager.get(ITEM_TAG).func_199886_b().toString()});
    }

    @Override
    public void registerData() {
        super.registerData();
        this.dataManager.register((ThreeData)ITEM_TAG, Tags.Items.INGOTS_IRON);
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            this.dataManager.register((ThreeData)SLOT_DATA.get(slot), (Object)(slot.func_188453_a() == EquipmentSlotType.Group.ARMOR ? 1 : 0));
        }
    }

    @Override
    public boolean test(LivingEntity entity) {
        Tag<Item> tag = this.dataManager.get(ITEM_TAG);
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            ItemStack stack = entity.func_184582_a(slot);
            if (!this.dataManager.get(SLOT_DATA.get(slot)).booleanValue() || !stack.func_190926_b() && stack.func_77973_b().func_206844_a(tag)) continue;
            return false;
        }
        return true;
    }

    static {
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            SLOT_DATA.put(slot, new BooleanThreeData(slot.func_188450_d().toLowerCase()).setSyncType(EnumSync.SELF).enableSetting("Determines if the item in the " + slot.func_188450_d() + " slot must have the specified tag"));
        }
    }
}

