/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability.condition;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.condition.Condition;
import net.threetag.threecore.ability.condition.ConditionType;
import net.threetag.threecore.util.threedata.EnumSync;
import net.threetag.threecore.util.threedata.IntegerThreeData;
import net.threetag.threecore.util.threedata.ThreeData;

public class XPCondition
extends Condition {
    public static final ThreeData<Integer> MIN = new IntegerThreeData("min").setSyncType(EnumSync.SELF).enableSetting("min", "The minimum xp level required for the condition to be true.");
    public static final ThreeData<Integer> MAX = new IntegerThreeData("max").setSyncType(EnumSync.SELF).enableSetting("max", "The maximum xp level required for the condition to be true.");

    public XPCondition(Ability ability) {
        super(ConditionType.XP, ability);
    }

    @Override
    public void registerData() {
        super.registerData();
        this.dataManager.register((ThreeData)MIN, (Object)0);
        this.dataManager.register((ThreeData)MAX, (Object)Integer.MAX_VALUE);
    }

    @Override
    public ITextComponent createTitle() {
        int max;
        int min = this.dataManager.get(MIN);
        if (min == (max = this.dataManager.get(MAX).intValue())) {
            return new TranslationTextComponent(Util.func_200697_a((String)"ability.condition", (ResourceLocation)this.type.getRegistryName()) + "_at" + ((Boolean)this.dataManager.get(INVERT) != false ? ".not" : ""), new Object[]{min});
        }
        if (max != Integer.MAX_VALUE) {
            return new TranslationTextComponent(Util.func_200697_a((String)"ability.condition", (ResourceLocation)this.type.getRegistryName()) + ((Boolean)this.dataManager.get(INVERT) != false ? ".not" : ""), new Object[]{min, max});
        }
        return new TranslationTextComponent(Util.func_200697_a((String)"ability.condition", (ResourceLocation)this.type.getRegistryName()) + "_min" + ((Boolean)this.dataManager.get(INVERT) != false ? ".not" : ""), new Object[]{min});
    }

    @Override
    public boolean test(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            int level = ((PlayerEntity)entity).field_71068_ca;
            return level >= this.dataManager.get(MIN) && level <= this.dataManager.get(MAX);
        }
        return false;
    }
}

