/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability.superpower;

import java.util.Arrays;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityGenerator;
import net.threetag.threecore.ability.AbilityMap;
import net.threetag.threecore.ability.IAbilityProvider;
import net.threetag.threecore.util.icon.IIcon;

public class Superpower
implements IAbilityProvider {
    protected final ResourceLocation id;
    protected ITextComponent name;
    protected IIcon icon;
    protected List<AbilityGenerator> abilityGenerators;

    public Superpower(ResourceLocation id, ITextComponent name, IIcon icon, AbilityGenerator ... abilityGenerators) {
        this.id = id;
        this.name = name;
        this.icon = icon;
        this.abilityGenerators = Arrays.asList(abilityGenerators);
    }

    public Superpower(ResourceLocation id, ITextComponent name, IIcon icon, List<AbilityGenerator> abilityGenerators) {
        this.id = id;
        this.name = name;
        this.icon = icon;
        this.abilityGenerators = abilityGenerators;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ITextComponent getName() {
        return this.name;
    }

    public IIcon getIcon() {
        return this.icon;
    }

    @Override
    public AbilityMap getAbilities() {
        AbilityMap abilityMap = new AbilityMap();
        this.abilityGenerators.forEach(a -> {
            Ability ability = a.create();
            ability.getAdditionalData().func_74757_a("IsFromSuperpower", true);
            abilityMap.put(a.key, ability);
        });
        return abilityMap;
    }
}

