/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.addonpacks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileFilter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.FallbackResourceManager;
import net.minecraft.resources.FilePack;
import net.minecraft.resources.FolderPack;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.ResourcePackType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.fml.packs.ResourcePackLoader;
import net.threetag.threecore.addonpacks.item.ItemParser;

public class AddonPackManager {
    private static AddonPackManager INSTANCE;
    public static final File DIRECTORY;
    private static final FileFilter FILE_FILTER;
    public static Gson GSON;
    public ResourcePackList<ResourcePackInfo> addonpackFinder = new ResourcePackList(ResourcePackInfo::new);
    private IResourceManager resourceManager = new FallbackResourceManager(ResourcePackType.SERVER_DATA);

    private AddonPackManager() {
        INSTANCE = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.addonpackFinder.func_198982_a((IPackFinder)new AddonPackFinder());
        Map modResourcePacks = ModList.get().getModFiles().stream().filter(mf -> !Objects.equals(mf.getModLoader(), "minecraft")).map(mf -> new ModFileResourcePack(mf.getFile())).collect(Collectors.toMap(ModFileResourcePack::getModFile, Function.identity()));
        this.addonpackFinder.func_198983_a();
        List<IResourcePack> list = this.addonpackFinder.func_198978_b().stream().map(ResourcePackInfo::func_195796_e).collect(Collectors.toList());
        list.forEach(pack -> this.resourceManager.func_199021_a(pack));
        modResourcePacks.forEach((f, p) -> this.resourceManager.func_199021_a((IResourcePack)p));
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new ItemParser());
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (Minecraft.func_71410_x() != null) {
                Minecraft.func_71410_x().func_195548_H().func_198982_a((IPackFinder)new AddonPackFinder());
            }
        });
    }

    public static void init() {
        if (INSTANCE == null) {
            INSTANCE = new AddonPackManager();
        }
    }

    public static AddonPackManager getInstance() {
        return INSTANCE;
    }

    public IResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @SubscribeEvent
    public void serverStarting(FMLServerAboutToStartEvent e) {
        e.getServer().field_195577_ad.func_198982_a((IPackFinder)new AddonPackFinder());
    }

    static {
        DIRECTORY = new File("addonpacks");
        FILE_FILTER = file -> {
            boolean isZip = file.isFile() && file.getName().endsWith(".zip");
            boolean hasMeta = file.isDirectory() && new File(file, "pack.mcmeta").isFile();
            return isZip || hasMeta;
        };
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    }

    private static class LambdaFriendlyPackFinder
    implements IPackFinder {
        private ResourcePackLoader.IPackInfoFinder wrapped;

        private LambdaFriendlyPackFinder(ResourcePackLoader.IPackInfoFinder wrapped) {
            this.wrapped = wrapped;
        }

        public <T extends ResourcePackInfo> void func_195730_a(Map<String, T> packList, ResourcePackInfo.IFactory<T> factory) {
            this.wrapped.addPackInfosToMap(packList, factory);
        }
    }

    private static class AddonPackFinder
    implements IPackFinder {
        private AddonPackFinder() {
        }

        public <T extends ResourcePackInfo> void func_195730_a(Map<String, T> map, ResourcePackInfo.IFactory<T> iFactory) {
            File[] files;
            if (!DIRECTORY.exists()) {
                DIRECTORY.mkdirs();
            }
            if ((files = DIRECTORY.listFiles(FILE_FILTER)) != null) {
                for (File file : files) {
                    String name = "addonpack:" + file.getName();
                    ResourcePackInfo container = ResourcePackInfo.func_195793_a((String)name, (boolean)true, this.createResourcePack(file), iFactory, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.TOP);
                    if (container == null) continue;
                    map.put(name, container);
                }
            }
        }

        private Supplier<IResourcePack> createResourcePack(File file) {
            return file.isDirectory() ? () -> new FolderPack(file) : () -> new FilePack(file);
        }
    }
}

