/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.block;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.energy.CapabilityEnergy;
import net.threetag.threecore.ThreeCoreServerConfig;
import net.threetag.threecore.tileentity.EnergyConduitTileEntity;

public class EnergyConduitBlock
extends Block
implements IWaterLoggable {
    private static final Direction[] FACING_VALUES = Direction.values();
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final EnumProperty<ConduitConnection> NORTH = EnumProperty.func_177709_a((String)"north", ConduitConnection.class);
    public static final EnumProperty<ConduitConnection> EAST = EnumProperty.func_177709_a((String)"east", ConduitConnection.class);
    public static final EnumProperty<ConduitConnection> SOUTH = EnumProperty.func_177709_a((String)"south", ConduitConnection.class);
    public static final EnumProperty<ConduitConnection> WEST = EnumProperty.func_177709_a((String)"west", ConduitConnection.class);
    public static final EnumProperty<ConduitConnection> UP = EnumProperty.func_177709_a((String)"up", ConduitConnection.class);
    public static final EnumProperty<ConduitConnection> DOWN = EnumProperty.func_177709_a((String)"down", ConduitConnection.class);
    public static final EnumProperty<ConduitDirection> DIRECTION = EnumProperty.func_177709_a((String)"direction", ConduitDirection.class);
    public static final Map<Direction, EnumProperty<ConduitConnection>> FACING_TO_PROPERTY_MAP = (Map)Util.func_200696_a((Object)Maps.newEnumMap(Direction.class), enumMap -> {
        enumMap.put(Direction.NORTH, NORTH);
        enumMap.put(Direction.EAST, EAST);
        enumMap.put(Direction.SOUTH, SOUTH);
        enumMap.put(Direction.WEST, WEST);
        enumMap.put(Direction.UP, UP);
        enumMap.put(Direction.DOWN, DOWN);
    });
    protected final VoxelShape[] shapes;
    protected final ConduitType type;

    public EnergyConduitBlock(Block.Properties properties, ConduitType type, float apothem) {
        super(properties);
        this.type = type;
        this.shapes = this.makeShapes(apothem);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a(NORTH, (Comparable)((Object)ConduitConnection.NONE))).func_206870_a(EAST, (Comparable)((Object)ConduitConnection.NONE))).func_206870_a(SOUTH, (Comparable)((Object)ConduitConnection.NONE))).func_206870_a(WEST, (Comparable)((Object)ConduitConnection.NONE))).func_206870_a(UP, (Comparable)((Object)ConduitConnection.NONE))).func_206870_a(DOWN, (Comparable)((Object)ConduitConnection.NONE)));
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(new TranslationTextComponent("block.threecore.conduit_tooltip", new Object[]{new StringTextComponent(this.type.getTransferRate().getAsInt() + "").func_211708_a(TextFormatting.GOLD), new StringTextComponent("FE").func_211708_a(TextFormatting.GRAY)}).func_211708_a(TextFormatting.GRAY));
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EnergyConduitTileEntity(this.type);
    }

    private VoxelShape[] makeShapes(float apothem) {
        float f = 0.5f - apothem;
        float f1 = 0.5f + apothem;
        VoxelShape voxelshape = Block.func_208617_a((double)(f * 16.0f), (double)(f * 16.0f), (double)(f * 16.0f), (double)(f1 * 16.0f), (double)(f1 * 16.0f), (double)(f1 * 16.0f));
        VoxelShape[] avoxelshape = new VoxelShape[FACING_VALUES.length];
        for (int i = 0; i < FACING_VALUES.length; ++i) {
            Direction direction = FACING_VALUES[i];
            avoxelshape[i] = VoxelShapes.func_197873_a((double)(0.5 + Math.min((double)(-apothem), (double)direction.func_82601_c() * 0.5)), (double)(0.5 + Math.min((double)(-apothem), (double)direction.func_96559_d() * 0.5)), (double)(0.5 + Math.min((double)(-apothem), (double)direction.func_82599_e() * 0.5)), (double)(0.5 + Math.max((double)apothem, (double)direction.func_82601_c() * 0.5)), (double)(0.5 + Math.max((double)apothem, (double)direction.func_96559_d() * 0.5)), (double)(0.5 + Math.max((double)apothem, (double)direction.func_82599_e() * 0.5)));
        }
        VoxelShape[] avoxelshape1 = new VoxelShape[64];
        for (int k = 0; k < 64; ++k) {
            VoxelShape voxelshape1 = voxelshape;
            for (int j = 0; j < FACING_VALUES.length; ++j) {
                if ((k & 1 << j) == 0) continue;
                voxelshape1 = VoxelShapes.func_197872_a((VoxelShape)voxelshape1, (VoxelShape)avoxelshape[j]);
            }
            avoxelshape1[k] = voxelshape1;
        }
        return avoxelshape1;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shapes[this.getShapeIndex(state)];
    }

    protected int getShapeIndex(BlockState state) {
        int i = 0;
        for (int j = 0; j < FACING_VALUES.length; ++j) {
            if (state.func_177229_b((IProperty)FACING_TO_PROPERTY_MAP.get(FACING_VALUES[j])) == ConduitConnection.NONE) continue;
            i |= 1 << j;
        }
        return i;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.makeConnections((IBlockReader)context.func_195991_k(), context.func_195995_a());
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return this.makeConnections((IBlockReader)worldIn, currentPos);
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState makeConnections(IBlockReader blockReader, BlockPos pos) {
        IFluidState fluidState = blockReader.func_204610_c(pos);
        boolean waterLogged = fluidState.func_206884_a(FluidTags.field_206959_a) && fluidState.func_206882_g() == 8;
        ConduitConnection down = EnergyConduitBlock.getConnection(blockReader, pos, Direction.DOWN);
        ConduitConnection up = EnergyConduitBlock.getConnection(blockReader, pos, Direction.UP);
        ConduitConnection north = EnergyConduitBlock.getConnection(blockReader, pos, Direction.NORTH);
        ConduitConnection south = EnergyConduitBlock.getConnection(blockReader, pos, Direction.SOUTH);
        ConduitConnection east = EnergyConduitBlock.getConnection(blockReader, pos, Direction.EAST);
        ConduitConnection west = EnergyConduitBlock.getConnection(blockReader, pos, Direction.WEST);
        ConduitDirection direction = EnergyConduitBlock.getDirection(north.hasConnection(), south.hasConnection(), east.hasConnection(), west.hasConnection(), up.hasConnection(), down.hasConnection());
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(waterLogged))).func_206870_a(DIRECTION, (Comparable)((Object)direction))).func_206870_a(DOWN, (Comparable)((Object)down))).func_206870_a(UP, (Comparable)((Object)up))).func_206870_a(NORTH, (Comparable)((Object)north))).func_206870_a(EAST, (Comparable)((Object)east))).func_206870_a(SOUTH, (Comparable)((Object)south))).func_206870_a(WEST, (Comparable)((Object)west));
    }

    public static ConduitConnection getConnection(IBlockReader reader, BlockPos pos, Direction direction) {
        TileEntity tileEntity = reader.func_175625_s(pos.func_177972_a(direction));
        if (tileEntity != null) {
            if (tileEntity instanceof EnergyConduitTileEntity) {
                return ConduitConnection.CONDUIT;
            }
            if (tileEntity.getCapability(CapabilityEnergy.ENERGY, direction.func_176734_d()).isPresent()) {
                return ConduitConnection.MACHINE;
            }
        }
        return ConduitConnection.NONE;
    }

    public static ConduitDirection getDirection(boolean north, boolean south, boolean east, boolean west, boolean up, boolean down) {
        if (north && south && !east && !west && !up && !down) {
            return ConduitDirection.X;
        }
        if (!north && !south && east && west && !up && !down) {
            return ConduitDirection.Z;
        }
        if (!north && !south && !east && !west && up && down) {
            return ConduitDirection.Y;
        }
        return ConduitDirection.MULTIPLE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, DIRECTION, WATERLOGGED});
    }

    public static enum ConduitType {
        GOLD(ThreeCoreServerConfig.ENERGY.GOLD_CONDUIT, "gold"),
        COPPER(ThreeCoreServerConfig.ENERGY.COPPER_CONDUIT, "copper"),
        SILVER(ThreeCoreServerConfig.ENERGY.SILVER_CONDUIT, "silver");

        protected IntSupplier transferRate = () -> transferRate.get();
        protected String name;

        private ConduitType(ForgeConfigSpec.ConfigValue<Integer> transferRate, String name) {
            this.name = name;
        }

        public IntSupplier getTransferRate() {
            return this.transferRate;
        }

        public String getName() {
            return this.name;
        }

        public static ConduitType getByName(String name) {
            for (ConduitType type : ConduitType.values()) {
                if (!type.getName().equalsIgnoreCase(name)) continue;
                return type;
            }
            return ConduitType.values()[0];
        }
    }

    public static enum ConduitDirection implements IStringSerializable
    {
        X("x"),
        Y("y"),
        Z("z"),
        MULTIPLE("multiple");

        private String name;

        private ConduitDirection(String name) {
            this.name = name;
        }

        public boolean hasCorner() {
            return this != MULTIPLE;
        }

        public String func_176610_l() {
            return this.name;
        }
    }

    public static enum ConduitConnection implements IStringSerializable
    {
        NONE("none"),
        CONDUIT("conduit"),
        MACHINE("machine");

        private String name;

        private ConduitConnection(String name) {
            this.name = name;
        }

        public boolean hasConnection() {
            return this != NONE;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

