/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.PacketDistributor;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.ability.AbilityMap;
import net.threetag.threecore.ability.IAbilityContainer;
import net.threetag.threecore.ability.IAbilityProvider;
import net.threetag.threecore.network.UpdateAbilityMessage;
import net.threetag.threecore.util.icon.IIcon;
import net.threetag.threecore.util.icon.ItemIcon;
import net.threetag.threecore.util.threedata.EnumSync;

public class ItemAbilityContainer
implements IAbilityContainer {
    public final ItemStack stack;
    public EquipmentSlotType slot;
    protected final AbilityMap map;
    public boolean init = false;

    public ItemAbilityContainer(ItemStack stack) {
        this.stack = stack;
        this.map = new AbilityMap();
    }

    @Override
    public void tick(LivingEntity entity) {
        for (EquipmentSlotType slots : EquipmentSlotType.values()) {
            if (entity.func_184582_a(slots) != this.stack) continue;
            this.slot = slots;
            break;
        }
        if (!this.init) {
            if (this.stack.func_196082_o().func_74764_b("Abilities")) {
                AbilityHelper.loadFromNBT(this.stack.func_196082_o().func_74775_l("Abilities"), this.map);
            } else if (this.stack.func_77973_b() instanceof IAbilityProvider && !entity.field_70170_p.field_72995_K) {
                this.addAbilities(null, (IAbilityProvider)this.stack.func_77973_b());
            } else {
                return;
            }
        }
        this.getAbilityMap().forEach((s, a) -> {
            a.container = this;
            a.tick(entity);
            if (a.sync != EnumSync.NONE || !this.init || a.dirty) {
                this.onUpdated(entity, (Ability)a, a.sync);
                a.sync = EnumSync.NONE;
            }
            if (a.dirty) {
                a.dirty = false;
                this.stack.func_196082_o().func_218657_a("Abilities", (INBT)AbilityHelper.saveToNBT(this.map));
            }
        });
        this.init = true;
    }

    @Override
    public void onUpdated(LivingEntity entity, Ability ability, EnumSync sync) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.stack.func_196082_o().func_218657_a("Abilities", (INBT)AbilityHelper.saveToNBT(this.map));
        if (sync != EnumSync.NONE && entity instanceof ServerPlayerEntity) {
            ThreeCore.NETWORK_CHANNEL.sendTo((Object)new UpdateAbilityMessage(entity.func_145782_y(), this.getId(), ability.getId(), ability.getUpdateTag()), ((ServerPlayerEntity)entity).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
        }
        if (sync == EnumSync.EVERYONE && entity.field_70170_p instanceof ServerWorld) {
            ThreeCore.NETWORK_CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new UpdateAbilityMessage(entity.func_145782_y(), this.getId(), ability.getId(), ability.getUpdateTag()));
        }
    }

    @Override
    public AbilityMap getAbilityMap() {
        return this.map;
    }

    @Override
    public ResourceLocation getId() {
        return new ResourceLocation("threecore", "item_" + this.slot.toString().toLowerCase());
    }

    @Override
    public ITextComponent getTitle() {
        return this.stack.func_200301_q();
    }

    @Override
    public IIcon getIcon() {
        return new ItemIcon(this.stack);
    }

    @Override
    public CompoundNBT getNbtTag(@Nonnull LivingEntity entity) {
        return this.stack.func_196082_o();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull LivingEntity entity, @Nonnull Capability<T> cap, @Nullable Direction side) {
        return this.stack.getCapability(cap, side);
    }
}

