/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.gui.ability;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.IAbilityContainer;
import net.threetag.threecore.client.gui.ability.AbilitiesScreen;
import net.threetag.threecore.client.gui.ability.AbilityTabEntry;
import net.threetag.threecore.client.gui.ability.AbilityTabType;

public class AbilityTabGui
extends AbstractGui {
    public static final int innerWidth = 234;
    public static final int innerHeight = 169;
    public static final int gridSize = 50;
    private final IAbilityContainer container;
    private final AbilityTabType type;
    private final int index;
    private List<AbilityTabEntry> abilities;
    private List<Connection> connections;
    private boolean centered;
    private double scrollX;
    private double scrollY;
    public float fade;
    private int minX = Integer.MAX_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int maxY = Integer.MIN_VALUE;

    public AbilityTabGui(IAbilityContainer container, AbilityTabType type, int index) {
        this.container = container;
        this.type = type;
        this.index = index;
        this.abilities = new LinkedList<AbilityTabEntry>();
        this.connections = new LinkedList<Connection>();
        this.init();
    }

    public void init() {
        LinkedList<AbilityTabEntry> root = new LinkedList<AbilityTabEntry>();
        for (Ability ability : this.container.getAbilities()) {
            if (((Boolean)ability.get(Ability.HIDDEN)).booleanValue()) continue;
            this.abilities.add(new AbilityTabEntry(ability));
        }
        for (AbilityTabEntry abilityTabEntry : this.abilities) {
            abilityTabEntry.updateRelatives(this.abilities);
        }
        int y = 0;
        for (AbilityTabEntry entry : this.abilities) {
            if (entry.parents.size() > 0) continue;
            entry.updatePosition(0.0, y, this);
            root.add(entry);
            ++y;
        }
        int n = this.longestRow();
        for (int j = 0; j < root.size(); ++j) {
            for (AbilityTabEntry entry : root) {
                for (AbilityTabEntry children : entry.children) {
                    if (entry.x != children.x) continue;
                    children.x += 1.0;
                    children.y = this.getFreeYPos(children.x, entry.y);
                }
            }
        }
        for (int x = 0; x < 100; ++x) {
            List<AbilityTabEntry> entries = this.getEntriesAtX(x);
            for (int n2 = 0; n2 < entries.size(); ++n2) {
                AbilityTabEntry entry = entries.get(n2);
                entry.y = (double)n / 2.0 - (double)entries.size() / 2.0 + (double)n2;
            }
        }
        for (AbilityTabEntry entry : this.abilities) {
            this.minX = (int)Math.min(entry.x * 50.0, (double)this.minX);
            this.minY = (int)Math.min(entry.y * 50.0, (double)this.minY);
            this.maxX = (int)Math.max(entry.x * 50.0, (double)this.maxX);
            this.maxY = (int)Math.max(entry.y * 50.0, (double)this.maxY);
            for (AbilityTabEntry child : entry.children) {
                int endY;
                int endX;
                int startY;
                int startX;
                Connection connection = new Connection();
                if (entry.children.size() == 1) {
                    startX = this.toCoord(entry.x);
                    startY = this.toCoord(entry.y, 1.0 / (double)(entry.children.size() + 1) * (double)(entry.children.indexOf((Object)child) + 1));
                    endX = this.toCoord(child.x);
                    endY = this.toCoord(child.y, 1.0 / (double)(child.parents.size() + 1) * (double)(child.parents.indexOf((Object)entry) + 1));
                    connection.addLine(new ConnectionLine(startX, startY, endX, startY));
                    connection.addLine(new ConnectionLine(endX, startY, endX, endY));
                } else {
                    startX = this.toCoord(entry.x);
                    startY = this.toCoord(entry.y, 1.0 / (double)(entry.children.size() + 1) * (double)(entry.children.indexOf((Object)child) + 1));
                    endX = this.toCoord(child.x);
                    endY = this.toCoord(child.y, 1.0 / (double)(child.parents.size() + 1) * (double)(child.parents.indexOf((Object)entry) + 1));
                    int midX = (startX + endX) / 2;
                    connection.addLine(new ConnectionLine(startX, startY, midX, startY));
                    connection.addLine(new ConnectionLine(midX, startY, midX, endY));
                    connection.addLine(new ConnectionLine(midX, endY, endX, endY));
                }
                Random random = new Random();
                connection.color = new Color(random.nextFloat(), random.nextFloat(), random.nextFloat());
                this.connections.add(connection);
            }
        }
    }

    private int toCoord(double d) {
        return this.toCoord(d, 0.5);
    }

    private int toCoord(double d, double height) {
        return (int)((d - 0.5) * 50.0 + 17.0 + 16.0 * height);
    }

    private int longestRow() {
        int l = 0;
        for (int i = 0; i < 100; ++i) {
            int k = this.getEntriesAtX(i).size();
            l = Math.max(l, k);
        }
        return l;
    }

    public List<AbilityTabEntry> getEntriesAtX(double x) {
        LinkedList<AbilityTabEntry> list = new LinkedList<AbilityTabEntry>();
        for (AbilityTabEntry entry : this.abilities) {
            if (entry.x != x) continue;
            list.add(entry);
        }
        return list;
    }

    public AbilityTabEntry getEntry(double x, double y) {
        for (AbilityTabEntry entry : this.abilities) {
            if (entry.x != x || entry.y != y) continue;
            return entry;
        }
        return null;
    }

    public double getFreeYPos(double x, double y) {
        for (int i = (int)y; i < 100; ++i) {
            if (this.getEntry(x, i) != null) continue;
            return i;
        }
        return 0.0;
    }

    public ITextComponent getTitle() {
        return this.container.getTitle();
    }

    public void drawTab(int x, int y, boolean selected) {
        this.type.draw(this, x, y, selected, this.index);
    }

    public void drawIcon(int x, int y) {
        this.type.drawIcon(x, y, this.index, this.container.getIcon());
    }

    public void drawContents() {
        if (!this.centered) {
            this.scrollX = 117 - (this.maxX + this.minX) / 2;
            this.scrollY = 84 - (this.maxY + this.minY) / 2;
            this.centered = true;
        }
        GlStateManager.depthFunc((int)518);
        AbilityTabGui.fill((int)0, (int)0, (int)234, (int)169, (int)-16777216);
        GlStateManager.depthFunc((int)515);
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(new ResourceLocation("textures/block/red_wool.png"));
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = MathHelper.func_76128_c((double)this.scrollX);
        int j = MathHelper.func_76128_c((double)this.scrollY);
        int k = i % 16;
        int l = j % 16;
        for (int i1 = -1; i1 <= 15; ++i1) {
            for (int j1 = -1; j1 <= 11; ++j1) {
                AbilityTabGui.blit((int)(k + 16 * i1), (int)(l + 16 * j1), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            }
        }
        for (Connection connection : this.connections) {
            connection.draw(this, i, j);
        }
        for (AbilityTabEntry entry : this.abilities) {
            entry.drawIcon(mc, i + (int)(entry.x * 50.0), j + (int)(entry.y * 50.0));
        }
    }

    public void drawToolTips(int mouseX, int mouseY, int x, int y, AbilitiesScreen screen, boolean overlayActive) {
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)200.0f);
        AbilityTabGui.fill((int)0, (int)0, (int)234, (int)169, (int)(MathHelper.func_76141_d((float)(this.fade * 255.0f)) << 24));
        boolean flag = false;
        if (!overlayActive) {
            int i = MathHelper.func_76128_c((double)this.scrollX);
            int j = MathHelper.func_76128_c((double)this.scrollY);
            if (mouseX > 0 && mouseX < 234 && mouseY > 0 && mouseY < 169) {
                for (AbilityTabEntry entry : this.abilities) {
                    if (!entry.isMouseOver(i, j, mouseX, mouseY)) continue;
                    flag = true;
                    entry.drawHover(i, j, this.fade, x, y, screen);
                    break;
                }
            }
        }
        GlStateManager.popMatrix();
        if (!overlayActive) {
            this.fade = flag ? MathHelper.func_76131_a((float)(this.fade + 0.02f), (float)0.0f, (float)0.3f) : MathHelper.func_76131_a((float)(this.fade - 0.04f), (float)0.0f, (float)1.0f);
        }
    }

    public AbilityTabEntry getAbilityHoveredOver(int mouseX, int mouseY, int x, int y) {
        int i = MathHelper.func_76128_c((double)this.scrollX);
        int j = MathHelper.func_76128_c((double)this.scrollY);
        if (mouseX > 0 && mouseX < 234 && mouseY > 0 && mouseY < 169) {
            for (AbilityTabEntry entry : this.abilities) {
                if (!entry.isMouseOver(i, j, mouseX, mouseY)) continue;
                return entry;
            }
        }
        return null;
    }

    public boolean isMouseOver(int mouseX, int mouseY, double p_195627_3_, double p_195627_5_) {
        return this.type.isMouseOver(mouseX, mouseY, this.index, p_195627_3_, p_195627_5_);
    }

    public void scroll(double x, double y) {
        if (this.maxX - this.minX > 234) {
            this.scrollX = MathHelper.func_151237_a((double)(this.scrollX + x), (double)(-(this.maxX - 234)), (double)0.0);
        }
        if (this.maxY - this.minY > 169) {
            this.scrollY = MathHelper.func_151237_a((double)(this.scrollY + y), (double)(-(this.maxY - 169)), (double)0.0);
        }
    }

    public static AbilityTabGui create(Minecraft minecraft, AbilitiesScreen screen, int index, IAbilityContainer container) {
        for (AbilityTabType tabType : AbilityTabType.values()) {
            if (index % AbilityTabType.MAX_TABS < tabType.getMax()) {
                return new AbilityTabGui(container, tabType, index % AbilityTabType.MAX_TABS);
            }
            index -= tabType.getMax();
        }
        return null;
    }

    public static class ConnectionLine {
        public int startX;
        public int startY;
        public int endX;
        public int endY;

        public ConnectionLine(int startX, int startY, int endX, int endY) {
            this.startX = Math.min(startX, endX);
            this.startY = Math.min(startY, endY);
            this.endX = Math.max(startX, endX);
            this.endY = Math.max(startY, endY);
        }

        public void draw(AbilityTabGui gui, int x, int y, boolean outline, Color color) {
            int colorCode = color.getRGB();
            if (outline) {
                if (this.startY == this.endY) {
                    gui.hLine(x + this.startX - 2, x + this.endX + 1, y + this.startY - 2, colorCode);
                    gui.hLine(x + this.startX - 2, x + this.endX + 1, y + this.startY + 1, colorCode);
                } else if (this.startX == this.endX) {
                    gui.vLine(x + this.startX - 2, y + this.startY - 2, y + this.endY + 1, colorCode);
                    gui.vLine(x + this.startX + 1, y + this.startY - 2, y + this.endY + 1, colorCode);
                }
            } else if (this.startY == this.endY) {
                gui.hLine(x + this.startX - 1, x + this.endX, y + this.startY - 1, colorCode);
                gui.hLine(x + this.startX - 1, x + this.endX, y + this.startY, colorCode);
            } else if (this.startX == this.endX) {
                gui.vLine(x + this.startX - 1, y + this.startY - 1, y + this.endY, colorCode);
                gui.vLine(x + this.startX, y + this.startY - 1, y + this.endY, colorCode);
            }
        }
    }

    public static class Connection {
        public Color color = Color.WHITE;
        public List<ConnectionLine> lines = new LinkedList<ConnectionLine>();

        public Connection(List<ConnectionLine> lines) {
            this.lines = lines;
        }

        public Connection() {
        }

        public Connection addLine(ConnectionLine line) {
            this.lines.add(line);
            return this;
        }

        public void draw(AbilityTabGui gui, int x, int y) {
            for (ConnectionLine lines : this.lines) {
                lines.draw(gui, x, y, true, Color.BLACK);
            }
            for (ConnectionLine lines : this.lines) {
                lines.draw(gui, x, y, false, this.color);
            }
        }
    }
}

