/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityClientEventHandler;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.ability.EnumAbilityColor;

public class AbilityBarRenderer {
    public static final ResourceLocation TEXTURE = new ResourceLocation("threecore", "textures/gui/ability_bar.png");
    public static int INDEX = 0;
    public static final int ENTRY_SHOW_AMOUNT = 5;

    public static List<Ability> getCurrentDisplayedAbilities(List<Ability> abilities) {
        abilities = abilities.stream().filter(a -> a.getConditionManager().isUnlocked() && (a.getConditionManager().needsKey() || a.getDataManager().get(Ability.SHOW_IN_BAR) != false) && a.getDataManager().get(Ability.HIDDEN) == false).collect(Collectors.toList());
        ArrayList<Ability> list = new ArrayList<Ability>();
        if (abilities.isEmpty()) {
            return list;
        }
        if (INDEX >= abilities.size()) {
            INDEX = 0;
        } else if (INDEX < 0) {
            INDEX = abilities.size() - 1;
        }
        list.add(abilities.get(INDEX));
        int i = INDEX + 1;
        for (int added = 1; list.size() < 5 && added < abilities.size(); ++added) {
            if (i >= abilities.size()) {
                i = 0;
            }
            list.add(abilities.get(i));
            ++i;
        }
        return list;
    }

    public static Ability getAbilityFromKey(int key) {
        if (key > 5) {
            return null;
        }
        List<Ability> list = AbilityBarRenderer.getCurrentDisplayedAbilities(AbilityHelper.getAbilities((LivingEntity)Minecraft.func_71410_x().field_71439_g));
        if (key < 0 || key >= list.size()) {
            return null;
        }
        return list.get(key);
    }

    public static int getKeyFromAbility(Ability ability, int pos) {
        if (ability.getDataManager().get(Ability.KEYBIND) > -1) {
            return ability.getDataManager().get(Ability.KEYBIND);
        }
        if (pos < AbilityClientEventHandler.ABILITY_KEYS.size()) {
            return AbilityClientEventHandler.ABILITY_KEYS.get(pos).getKey().func_197937_c();
        }
        return -1;
    }

    public static void scroll(boolean up) {
        INDEX = up ? ++INDEX : --INDEX;
    }

    @SubscribeEvent
    public void renderHUD(RenderGameOverlayEvent.Post e) {
        Minecraft mc = Minecraft.func_71410_x();
        if (e.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            Tessellator tes = Tessellator.func_178181_a();
            BufferBuilder bb = tes.func_178180_c();
            List<Ability> abilities = AbilityBarRenderer.getCurrentDisplayedAbilities(AbilityHelper.getAbilities((LivingEntity)mc.field_71439_g));
            boolean showName = mc.field_71456_v.func_146158_b().func_146241_e();
            RenderHelper.func_74520_c();
            GlStateManager.enableBlend();
            for (int i = 0; i < abilities.size(); ++i) {
                Ability ability = abilities.get(i);
                EnumAbilityColor color = ability.getColor();
                String name = showName ? ability.getDataManager().get(Ability.TITLE).func_150254_d() : InputMappings.func_216507_a((int)AbilityBarRenderer.getKeyFromAbility(ability, i));
                int nameLength = mc.field_71466_p.func_78256_a(name);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.field_71446_o.func_110577_a(TEXTURE);
                mc.field_71456_v.blit(7, 7 + i * 22, color.getX(), color.getY(), 22, 22);
                if (ability.getConditionManager().isEnabled()) {
                    mc.field_71456_v.blit(7, 7 + i * 22, color.getX(), color.getY() + 44, 22, 22);
                }
                ability.drawIcon(mc, (AbstractGui)mc.field_71456_v, 10, 10 + i * 22);
                if (!ability.getConditionManager().needsKey()) continue;
                GlStateManager.disableTexture();
                GlStateManager.disableCull();
                GlStateManager.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
                bb.func_181668_a(9, DefaultVertexFormats.field_181705_e);
                bb.func_181662_b(29.0, (double)(10 + i * 22 + 1), 0.0).func_181675_d();
                bb.func_181662_b((double)(29 + nameLength + 8), (double)(10 + i * 22 + 1), 0.0).func_181675_d();
                bb.func_181662_b((double)(29 + nameLength + 8), (double)(10 + i * 22 + 15), 0.0).func_181675_d();
                bb.func_181662_b(29.0, (double)(10 + i * 22 + 15), 0.0).func_181675_d();
                tes.func_78381_a();
                GlStateManager.enableTexture();
                mc.field_71456_v.drawString(mc.field_71466_p, name, 34, 10 + i * 22 + 4, 0xFFFFFF);
            }
            GlStateManager.disableBlend();
            RenderHelper.func_74518_a();
        }
    }
}

