/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.renderer.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayer;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayerContext;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayerProvider;
import net.threetag.threecore.client.renderer.entity.modellayer.ModelLayerContext;

public class PlayerHandRenderer {
    public static void renderRightArm(PlayerRenderer playerRenderer, AbstractClientPlayerEntity clientPlayer) {
        playerRenderer.func_177138_b(clientPlayer);
        PlayerHandRenderer.renderItemLayers(clientPlayer, EquipmentSlotType.HEAD, playerRenderer, HandSide.RIGHT);
        PlayerHandRenderer.renderItemLayers(clientPlayer, EquipmentSlotType.CHEST, playerRenderer, HandSide.RIGHT);
        PlayerHandRenderer.renderItemLayers(clientPlayer, EquipmentSlotType.LEGS, playerRenderer, HandSide.RIGHT);
        PlayerHandRenderer.renderItemLayers(clientPlayer, EquipmentSlotType.FEET, playerRenderer, HandSide.RIGHT);
        ModelLayerContext context = new ModelLayerContext((Entity)clientPlayer);
        for (Ability ability : AbilityHelper.getAbilities((LivingEntity)clientPlayer)) {
            if (!(ability instanceof IModelLayerProvider) || !ability.getConditionManager().isEnabled()) continue;
            PlayerHandRenderer.renderLayers((IModelLayerProvider)((Object)ability), context, playerRenderer, HandSide.RIGHT);
        }
    }

    public static void renderLeftArm(PlayerRenderer playerRenderer, AbstractClientPlayerEntity clientPlayer) {
        playerRenderer.func_177139_c(clientPlayer);
        PlayerHandRenderer.renderItemLayers(clientPlayer, EquipmentSlotType.HEAD, playerRenderer, HandSide.LEFT);
        PlayerHandRenderer.renderItemLayers(clientPlayer, EquipmentSlotType.CHEST, playerRenderer, HandSide.LEFT);
        PlayerHandRenderer.renderItemLayers(clientPlayer, EquipmentSlotType.LEGS, playerRenderer, HandSide.LEFT);
        PlayerHandRenderer.renderItemLayers(clientPlayer, EquipmentSlotType.FEET, playerRenderer, HandSide.LEFT);
        ModelLayerContext context = new ModelLayerContext((Entity)clientPlayer);
        for (Ability ability : AbilityHelper.getAbilities((LivingEntity)clientPlayer)) {
            if (!(ability instanceof IModelLayerProvider) || !ability.getConditionManager().isEnabled()) continue;
            PlayerHandRenderer.renderLayers((IModelLayerProvider)((Object)ability), context, playerRenderer, HandSide.LEFT);
        }
    }

    public static void renderItemLayers(AbstractClientPlayerEntity playerEntity, EquipmentSlotType slot, PlayerRenderer playerRenderer, HandSide handSide) {
        ItemStack stack = playerEntity.func_184582_a(slot);
        ModelLayerContext context = new ModelLayerContext((LivingEntity)playerEntity, stack, slot);
        if (stack.func_77973_b() instanceof IModelLayerProvider) {
            for (IModelLayer layer : ((IModelLayerProvider)stack.func_77973_b()).getModelLayers(context)) {
                if (!layer.isActive(context)) continue;
                GlStateManager.pushMatrix();
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                layer.renderArm(handSide, context, playerRenderer);
                GlStateManager.popMatrix();
            }
        }
    }

    public static void renderLayers(IModelLayerProvider provider, IModelLayerContext context, PlayerRenderer playerRenderer, HandSide handSide) {
        for (IModelLayer layer : provider.getModelLayers(context)) {
            if (!layer.isActive(context)) continue;
            GlStateManager.pushMatrix();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            layer.renderArm(handSide, context, playerRenderer);
            GlStateManager.popMatrix();
        }
    }
}

