/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.renderer.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayer;
import net.threetag.threecore.client.renderer.entity.modellayer.ModelLayerContext;
import net.threetag.threecore.client.renderer.entity.modellayer.ModelLayerLoader;
import net.threetag.threecore.entity.ProjectileEntity;
import net.threetag.threecore.util.RenderUtil;

public class ProjectileEntityRenderer
extends SpriteRenderer<ProjectileEntity> {
    public ProjectileEntityRenderer(EntityRendererManager rendererManager, ItemRenderer itemRenderer) {
        super(rendererManager, itemRenderer, 1.0f);
    }

    public void doRender(ProjectileEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (entity.getRenderedItem().func_190926_b()) {
            IModelLayer layer;
            if (entity.renderInfo.isEnergy()) {
                this.preRender(entity, x, y, z, entityYaw, partialTicks);
                GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                RenderUtil.drawGlowingLine(0.05f, 1.0f, entity.renderInfo.getColor(), true, true, true);
                GlStateManager.popMatrix();
            } else if (entity.renderInfo.getModelLayer() != null && (layer = ModelLayerLoader.getModelLayer(entity.renderInfo.getModelLayer())) != null) {
                this.preRender(entity, x, y, z, entityYaw, partialTicks);
                GlStateManager.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                layer.render(new ModelLayerContext((Entity)entity), null, 0.0f, 0.0f, partialTicks, 0.0f, 0.0f, 0.0f, 0.0625f);
                GlStateManager.popMatrix();
            }
        } else {
            super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
        }
    }

    private void preRender(ProjectileEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        Vec3d vec1 = new Vec3d(entity.field_70142_S, entity.field_70137_T, entity.field_70136_U);
        Vec3d vec2 = new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        vec1 = vec2.func_178788_d(vec1);
        vec2 = vec2.func_178788_d(vec2);
        vec1 = vec1.func_72432_b();
        double x_ = vec2.field_72450_a - vec1.field_72450_a;
        double y_ = vec2.field_72448_b - vec1.field_72448_b;
        double z_ = vec2.field_72449_c - vec1.field_72449_c;
        double diff = MathHelper.func_76133_a((double)(x_ * x_ + z_ * z_));
        float yaw = (float)(Math.atan2(z_, x_) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(y_, diff) * 180.0 / Math.PI));
        GlStateManager.rotatef((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
    }
}

