/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.renderer.entity.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.HandSide;
import net.minecraft.util.JSONUtils;
import net.threetag.threecore.client.renderer.entity.model.EntityModelParser;
import net.threetag.threecore.client.renderer.entity.model.IArmRenderingModel;
import net.threetag.threecore.client.renderer.entity.model.ISlotDependentVisibility;
import net.threetag.threecore.util.PlayerUtil;

public class BipedModelParser
extends EntityModelParser {
    @Override
    public EntityModel apply(JsonObject jsonObject) {
        ParsedBipedModel model = new ParsedBipedModel(this.parseModelScales(jsonObject.get("scale")), BipedArmType.getFromName(JSONUtils.func_151219_a((JsonObject)jsonObject, (String)"arm_type", (String)"default")), JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"texture_width", (int)64), JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"texture_height", (int)64));
        if (JSONUtils.func_151204_g((JsonObject)jsonObject, (String)"cubes")) {
            JsonArray cubes = JSONUtils.func_151214_t((JsonObject)jsonObject, (String)"cubes");
            for (int i = 0; i < cubes.size(); ++i) {
                JsonObject cubeJson = cubes.get(i).getAsJsonObject();
                RendererModel parent = this.getPart(JSONUtils.func_151219_a((JsonObject)cubeJson, (String)"parent", (String)""), model);
                if (parent != null) {
                    parent.func_78792_a(BipedModelParser.parseRendererModel(cubeJson, model));
                    continue;
                }
                model.addCube(BipedModelParser.parseRendererModel(cubeJson, model));
            }
        }
        if (JSONUtils.func_151204_g((JsonObject)jsonObject, (String)"visibility_overrides")) {
            JsonObject overrides = JSONUtils.func_152754_s((JsonObject)jsonObject, (String)"visibility_overrides");
            overrides.entrySet().forEach(entry -> {
                RendererModel part = this.getPart((String)entry.getKey(), model);
                if (part != null) {
                    model.addVisibilityOverride(part, JSONUtils.func_151212_i((JsonObject)overrides, (String)((String)entry.getKey())));
                }
            });
        }
        return model;
    }

    public Function<String, Float> parseModelScales(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            return s -> Float.valueOf(jsonElement.getAsFloat());
        }
        if (jsonElement.isJsonObject()) {
            HashMap scales = Maps.newHashMap();
            AtomicReference<Float> fallback = new AtomicReference<Float>(Float.valueOf(-999.0f));
            jsonElement.getAsJsonObject().entrySet().forEach(entry -> {
                if (((String)entry.getKey()).equalsIgnoreCase("fallback")) {
                    fallback.set(Float.valueOf(((JsonElement)entry.getValue()).getAsFloat()));
                } else {
                    scales.put(entry.getKey(), Float.valueOf(((JsonElement)entry.getValue()).getAsFloat()));
                }
            });
            return s -> {
                if (scales.containsKey(s)) {
                    return (Float)scales.get(s);
                }
                return ((Float)fallback.get()).floatValue() <= -999.0f ? Float.valueOf(s.equalsIgnoreCase("head") ? 0.5f : 0.25f) : (Float)fallback.get();
            };
        }
        throw new JsonParseException("Model scale must be either a single float or a json object with each model part!");
    }

    public RendererModel getPart(String name, ParsedBipedModel model) {
        if (name.equalsIgnoreCase("head")) {
            return model.field_78116_c;
        }
        if (name.equalsIgnoreCase("head_overlay")) {
            return model.field_178720_f;
        }
        if (name.equalsIgnoreCase("chest")) {
            return model.field_78115_e;
        }
        if (name.equalsIgnoreCase("chest_overlay")) {
            return model.bipedBodyWear;
        }
        if (name.equalsIgnoreCase("right_arm")) {
            return model.field_178723_h;
        }
        if (name.equalsIgnoreCase("right_arm_overlay")) {
            return model.bipedRightArmwear;
        }
        if (name.equalsIgnoreCase("left_arm")) {
            return model.field_178724_i;
        }
        if (name.equalsIgnoreCase("left_arm_overlay")) {
            return model.bipedLeftArmwear;
        }
        if (name.equalsIgnoreCase("right_leg")) {
            return model.field_178721_j;
        }
        if (name.equalsIgnoreCase("right_leg_overlay")) {
            return model.bipedRightLegwear;
        }
        if (name.equalsIgnoreCase("left_leg")) {
            return model.field_178722_k;
        }
        if (name.equalsIgnoreCase("left_leg_overlay")) {
            return model.bipedLeftLegwear;
        }
        return null;
    }

    public static enum BipedArmType {
        NORMAL("normal"),
        SMALL("small"),
        FIXED("fixed");

        private final String name;

        private BipedArmType(String name) {
            this.name = name;
        }

        public static BipedArmType getFromName(String name) {
            for (BipedArmType type : BipedArmType.values()) {
                if (!type.name.equalsIgnoreCase(name)) continue;
                return type;
            }
            return NORMAL;
        }
    }

    public static class ParsedBipedModel<T extends LivingEntity>
    extends BipedModel<T>
    implements ISlotDependentVisibility,
    IArmRenderingModel {
        public List<RendererModel> cubes = Lists.newLinkedList();
        public Map<RendererModel, Boolean> visibilityOverrides = Maps.newHashMap();
        public final RendererModel bipedLeftArmwear;
        public final RendererModel bipedRightArmwear;
        public final RendererModel bipedLeftLegwear;
        public final RendererModel bipedRightLegwear;
        public final RendererModel bipedBodyWear;
        private final BipedArmType bipedArmType;

        public ParsedBipedModel(Function<String, Float> scales, BipedArmType bipedArmType, int textureWidth, int textureHeight) {
            super(0.0f, 0.0f, textureWidth, textureHeight);
            this.bipedArmType = bipedArmType;
            this.field_78116_c = new RendererModel((Model)this, 0, 0);
            this.field_78116_c.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, scales.apply("head").floatValue());
            this.field_78116_c.func_78793_a(0.0f, 0.0f, 0.0f);
            this.field_178720_f = new RendererModel((Model)this, 32, 0);
            this.field_178720_f.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, scales.apply("head").floatValue() + 0.5f);
            this.field_178720_f.func_78793_a(0.0f, 0.0f, 0.0f);
            this.field_78115_e = new RendererModel((Model)this, 16, 16);
            this.field_78115_e.func_78790_a(-4.0f, 0.0f, -2.0f, 8, 12, 4, scales.apply("chest").floatValue());
            this.field_78115_e.func_78793_a(0.0f, 0.0f, 0.0f);
            this.field_178721_j = new RendererModel((Model)this, 0, 16);
            this.field_178721_j.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 12, 4, scales.apply("right_leg").floatValue());
            this.field_178721_j.func_78793_a(-1.9f, 12.0f, 0.0f);
            if (bipedArmType == BipedArmType.SMALL) {
                this.field_178724_i = new RendererModel((Model)this, 32, 48);
                this.field_178724_i.func_78790_a(-1.0f, -2.0f, -2.0f, 3, 12, 4, scales.apply("left_arm").floatValue());
                this.field_178724_i.func_78793_a(5.0f, 2.5f, 0.0f);
                this.field_178723_h = new RendererModel((Model)this, 40, 16);
                this.field_178723_h.func_78790_a(-2.0f, -2.0f, -2.0f, 3, 12, 4, scales.apply("right_arm").floatValue());
                this.field_178723_h.func_78793_a(-5.0f, 2.5f, 0.0f);
                this.bipedLeftArmwear = new RendererModel((Model)this, 48, 48);
                this.bipedLeftArmwear.func_78790_a(-1.0f, -2.0f, -2.0f, 3, 12, 4, scales.apply("left_arm").floatValue() + 0.25f);
                this.bipedLeftArmwear.func_78793_a(5.0f, 2.5f, 0.0f);
                this.bipedRightArmwear = new RendererModel((Model)this, 40, 32);
                this.bipedRightArmwear.func_78790_a(-2.0f, -2.0f, -2.0f, 3, 12, 4, scales.apply("right_arm").floatValue() + 0.25f);
                this.bipedRightArmwear.func_78793_a(-5.0f, 2.5f, 10.0f);
            } else {
                this.field_178724_i = new RendererModel((Model)this, 32, 48);
                this.field_178724_i.func_78790_a(-1.0f, -2.0f, -2.0f, 4, 12, 4, scales.apply("left_arm").floatValue());
                this.field_178724_i.func_78793_a(5.0f, 2.0f, 0.0f);
                this.field_178723_h = new RendererModel((Model)this, 40, 16);
                this.field_178723_h.func_78790_a(-3.0f, -2.0f, -2.0f, 4, 12, 4, scales.apply("right_arm").floatValue());
                this.field_178723_h.func_78793_a(-5.0f, 2.0f, 0.0f);
                this.bipedLeftArmwear = new RendererModel((Model)this, 48, 48);
                this.bipedLeftArmwear.func_78790_a(-1.0f, -2.0f, -2.0f, 4, 12, 4, scales.apply("left_arm").floatValue() + 0.25f);
                this.bipedLeftArmwear.func_78793_a(5.0f, 2.0f, 0.0f);
                this.bipedRightArmwear = new RendererModel((Model)this, 40, 32);
                this.bipedRightArmwear.func_78790_a(-3.0f, -2.0f, -2.0f, 4, 12, 4, scales.apply("right_arm").floatValue() + 0.25f);
                this.bipedRightArmwear.func_78793_a(-5.0f, 2.0f, 10.0f);
            }
            this.field_178722_k = new RendererModel((Model)this, 16, 48);
            this.field_178722_k.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 12, 4, scales.apply("left_leg").floatValue());
            this.field_178722_k.func_78793_a(1.9f, 12.0f, 0.0f);
            this.bipedLeftLegwear = new RendererModel((Model)this, 0, 48);
            this.bipedLeftLegwear.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 12, 4, scales.apply("left_leg").floatValue() + 0.25f);
            this.bipedLeftLegwear.func_78793_a(1.9f, 12.0f, 0.0f);
            this.bipedRightLegwear = new RendererModel((Model)this, 0, 32);
            this.bipedRightLegwear.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 12, 4, scales.apply("right_leg").floatValue() + 0.25f);
            this.bipedRightLegwear.func_78793_a(-1.9f, 12.0f, 0.0f);
            this.bipedBodyWear = new RendererModel((Model)this, 16, 32);
            this.bipedBodyWear.func_78790_a(-4.0f, 0.0f, -2.0f, 8, 12, 4, scales.apply("chest").floatValue() + 0.25f);
            this.bipedBodyWear.func_78793_a(0.0f, 0.0f, 0.0f);
        }

        public ParsedBipedModel addCube(RendererModel rendererModel) {
            this.cubes.add(rendererModel);
            return this;
        }

        public void addVisibilityOverride(RendererModel rendererModel, boolean visible) {
            this.visibilityOverrides.put(rendererModel, visible);
        }

        @Override
        public void setSlotVisibility(EquipmentSlotType slot) {
            this.func_178719_a(false);
            switch (slot) {
                case HEAD: {
                    this.field_78116_c.field_78806_j = true;
                    this.field_178720_f.field_78806_j = true;
                    break;
                }
                case CHEST: {
                    this.field_78115_e.field_78806_j = true;
                    this.bipedBodyWear.field_78806_j = true;
                    this.field_178723_h.field_78806_j = true;
                    this.bipedRightArmwear.field_78806_j = true;
                    this.field_178724_i.field_78806_j = true;
                    this.bipedLeftArmwear.field_78806_j = true;
                    break;
                }
                case LEGS: {
                    this.field_78115_e.field_78806_j = true;
                    this.bipedBodyWear.field_78806_j = true;
                    this.field_178721_j.field_78806_j = true;
                    this.bipedRightLegwear.field_78806_j = true;
                    this.field_178722_k.field_78806_j = true;
                    this.bipedLeftLegwear.field_78806_j = true;
                    break;
                }
                case FEET: {
                    this.field_178721_j.field_78806_j = true;
                    this.bipedRightLegwear.field_78806_j = true;
                    this.field_178722_k.field_78806_j = true;
                    this.bipedLeftLegwear.field_78806_j = true;
                }
            }
            for (Map.Entry<RendererModel, Boolean> override : this.visibilityOverrides.entrySet()) {
                override.getKey().field_78806_j = override.getValue();
            }
        }

        public void func_78088_a(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (this.bipedArmType == BipedArmType.FIXED) {
                boolean smallArms = entityIn instanceof PlayerEntity && PlayerUtil.hasSmallArms((PlayerEntity)entityIn);
                this.bipedRightArmwear.field_78797_d = smallArms ? 2.5f : 2.0f;
                this.field_178723_h.field_78797_d = this.bipedRightArmwear.field_78797_d;
                this.bipedLeftArmwear.field_78797_d = this.bipedRightArmwear.field_78797_d;
                this.field_178724_i.field_78797_d = this.bipedRightArmwear.field_78797_d;
            }
            super.func_78088_a(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            GlStateManager.pushMatrix();
            if (this.field_217114_e) {
                GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.translatef((float)0.0f, (float)(24.0f * scale), (float)0.0f);
                this.bipedLeftLegwear.func_78785_a(scale);
                this.bipedRightLegwear.func_78785_a(scale);
                this.bipedLeftArmwear.func_78785_a(scale);
                this.bipedRightArmwear.func_78785_a(scale);
                this.bipedBodyWear.func_78785_a(scale);
            } else {
                if (entityIn.func_213287_bg()) {
                    GlStateManager.translatef((float)0.0f, (float)0.2f, (float)0.0f);
                }
                this.bipedLeftLegwear.func_78785_a(scale);
                this.bipedRightLegwear.func_78785_a(scale);
                this.bipedLeftArmwear.func_78785_a(scale);
                this.bipedRightArmwear.func_78785_a(scale);
                this.bipedBodyWear.func_78785_a(scale);
            }
            for (RendererModel cube : this.cubes) {
                cube.func_78785_a(scale);
            }
            GlStateManager.popMatrix();
        }

        public void func_212844_a_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
            if (entityIn instanceof ArmorStandEntity) {
                ArmorStandEntity armorStandEntity = (ArmorStandEntity)entityIn;
                this.bipedLeftArmwear.field_78806_j = this.field_178723_h.field_78806_j && ((ArmorStandEntity)entityIn).func_175402_q();
                this.field_178724_i.field_78806_j = this.bipedLeftArmwear.field_78806_j;
                this.bipedRightArmwear.field_78806_j = this.bipedLeftArmwear.field_78806_j;
                this.field_178723_h.field_78806_j = this.bipedLeftArmwear.field_78806_j;
                this.field_78116_c.field_78795_f = (float)Math.PI / 180 * armorStandEntity.func_175418_s().func_179415_b();
                this.field_78116_c.field_78796_g = (float)Math.PI / 180 * armorStandEntity.func_175418_s().func_179416_c();
                this.field_78116_c.field_78808_h = (float)Math.PI / 180 * armorStandEntity.func_175418_s().func_179413_d();
                this.field_78115_e.field_78795_f = (float)Math.PI / 180 * armorStandEntity.func_175408_t().func_179415_b();
                this.field_78115_e.field_78796_g = (float)Math.PI / 180 * armorStandEntity.func_175408_t().func_179416_c();
                this.field_78115_e.field_78808_h = (float)Math.PI / 180 * armorStandEntity.func_175408_t().func_179413_d();
                this.field_178724_i.field_78795_f = (float)Math.PI / 180 * armorStandEntity.func_175404_u().func_179415_b();
                this.field_178724_i.field_78796_g = (float)Math.PI / 180 * armorStandEntity.func_175404_u().func_179416_c();
                this.field_178724_i.field_78808_h = (float)Math.PI / 180 * armorStandEntity.func_175404_u().func_179413_d();
                this.field_178723_h.field_78795_f = (float)Math.PI / 180 * armorStandEntity.func_175411_v().func_179415_b();
                this.field_178723_h.field_78796_g = (float)Math.PI / 180 * armorStandEntity.func_175411_v().func_179416_c();
                this.field_178723_h.field_78808_h = (float)Math.PI / 180 * armorStandEntity.func_175411_v().func_179413_d();
                this.field_178722_k.field_78795_f = (float)Math.PI / 180 * armorStandEntity.func_175403_w().func_179415_b();
                this.field_178722_k.field_78796_g = (float)Math.PI / 180 * armorStandEntity.func_175403_w().func_179416_c();
                this.field_178722_k.field_78808_h = (float)Math.PI / 180 * armorStandEntity.func_175403_w().func_179413_d();
                this.field_178721_j.field_78795_f = (float)Math.PI / 180 * armorStandEntity.func_175407_x().func_179415_b();
                this.field_178721_j.field_78796_g = (float)Math.PI / 180 * armorStandEntity.func_175407_x().func_179416_c();
                this.field_178721_j.field_78808_h = (float)Math.PI / 180 * armorStandEntity.func_175407_x().func_179413_d();
                this.field_178720_f.func_217177_a(this.field_78116_c);
                this.field_178723_h.field_78798_e = 0.0f;
                this.field_178723_h.field_78800_c = -5.0f;
                this.field_178724_i.field_78798_e = 0.0f;
                this.field_178724_i.field_78800_c = 5.0f;
                this.field_78115_e.func_78793_a(0.0f, 0.0f, 0.0f);
                this.bipedBodyWear.func_78793_a(0.0f, 0.0f, 0.0f);
                this.field_78116_c.func_78793_a(0.0f, 0.0f, 0.0f);
                this.field_178720_f.func_78793_a(0.0f, 0.0f, 0.0f);
                this.field_178722_k.func_78793_a(1.9f, 12.0f, 0.0f);
                this.field_178721_j.func_78793_a(-1.9f, 12.0f, 0.0f);
                this.bipedLeftLegwear.func_78793_a(1.9f, 12.0f, 0.0f);
                this.bipedRightLegwear.func_78793_a(-1.9f, 12.0f, 0.0f);
                if (this.bipedArmType == BipedArmType.SMALL) {
                    this.field_178724_i.func_78793_a(5.0f, 2.5f, 0.0f);
                    this.field_178723_h.func_78793_a(-5.0f, 2.5f, 0.0f);
                    this.bipedLeftArmwear.func_78793_a(5.0f, 2.5f, 0.0f);
                    this.bipedRightArmwear.func_78793_a(-5.0f, 2.5f, 10.0f);
                } else {
                    this.field_178724_i.func_78793_a(5.0f, 2.0f, 0.0f);
                    this.bipedLeftArmwear.func_78793_a(5.0f, 2.0f, 0.0f);
                    this.bipedRightArmwear.func_78793_a(-5.0f, 2.0f, 10.0f);
                }
            } else {
                super.func_212844_a_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
                this.field_78116_c.field_78808_h = 0.0f;
            }
            this.bipedLeftLegwear.func_217177_a(this.field_178722_k);
            this.bipedRightLegwear.func_217177_a(this.field_178721_j);
            this.bipedLeftArmwear.func_217177_a(this.field_178724_i);
            this.bipedRightArmwear.func_217177_a(this.field_178723_h);
            this.bipedBodyWear.func_217177_a(this.field_78115_e);
        }

        public void func_178719_a(boolean visible) {
            super.func_178719_a(visible);
            this.bipedLeftArmwear.field_78806_j = visible;
            this.bipedRightArmwear.field_78806_j = visible;
            this.bipedLeftLegwear.field_78806_j = visible;
            this.bipedRightLegwear.field_78806_j = visible;
            this.bipedBodyWear.field_78806_j = visible;
        }

        @Override
        public void renderArm(HandSide handSide) {
            if (handSide == HandSide.RIGHT) {
                this.field_178723_h.field_78795_f = 0.0f;
                this.field_178723_h.func_78785_a(0.0625f);
                this.bipedRightArmwear.field_78795_f = 0.0f;
                this.bipedRightArmwear.func_78785_a(0.0625f);
            } else {
                this.field_178724_i.field_78795_f = 0.0f;
                this.field_178724_i.func_78785_a(0.0625f);
                this.bipedLeftArmwear.field_78795_f = 0.0f;
                this.bipedLeftArmwear.func_78785_a(0.0625f);
            }
        }
    }
}

