/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.renderer.entity.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.client.renderer.entity.model.BipedModelParser;
import net.threetag.threecore.client.renderer.entity.model.EntityModelParser;
import net.threetag.threecore.client.renderer.entity.model.ModelRegistry;

@OnlyIn(value=Dist.CLIENT)
public class EntityModelManager
extends JsonReloadListener {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static Map<ResourceLocation, Function<JsonObject, EntityModel>> PARSER = Maps.newHashMap();

    public EntityModelManager() {
        super(GSON, "models/entity");
    }

    protected Map<ResourceLocation, JsonObject> func_212854_a_(IResourceManager resourceManagerIn, IProfiler profilerIn) {
        return super.func_212854_a_(resourceManagerIn, profilerIn);
    }

    protected void apply(Map<ResourceLocation, JsonObject> splashList, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        for (Map.Entry<ResourceLocation, JsonObject> entry : splashList.entrySet()) {
            try {
                EntityModel model = EntityModelManager.parseModel(entry.getValue());
                ModelRegistry.registerModel(entry.getKey().toString(), (Model)model);
            }
            catch (Exception e) {
                ThreeCore.LOGGER.error("Parsing error loading entity model {}", (Object)entry.getKey(), (Object)e);
            }
            ThreeCore.LOGGER.info("Loaded entity model {}", (Object)entry.getKey());
        }
    }

    public static void registerModelParser(ResourceLocation resourceLocation, Function<JsonObject, EntityModel> function) {
        Preconditions.checkNotNull((Object)resourceLocation);
        Preconditions.checkNotNull(function);
        PARSER.put(resourceLocation, function);
    }

    public static EntityModel parseModel(JsonObject json) {
        Function<JsonObject, EntityModel> function = PARSER.get(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"type")));
        if (function == null) {
            throw new JsonParseException("The entity model type '" + JSONUtils.func_151200_h((JsonObject)json, (String)"type") + "' does not exist!");
        }
        EntityModel model = function.apply(json);
        return Objects.requireNonNull(model);
    }

    static {
        EntityModelManager.registerModelParser(new ResourceLocation("threecore", "default"), new EntityModelParser());
        EntityModelManager.registerModelParser(new ResourceLocation("threecore", "biped"), new BipedModelParser());
    }
}

