/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.renderer.entity.modellayer;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.LazyLoadBase;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayer;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayerContext;
import net.threetag.threecore.client.renderer.entity.modellayer.ModelLayerManager;
import net.threetag.threecore.client.renderer.entity.modellayer.predicates.IModelLayerPredicate;

public class CompoundModelLayer
implements IModelLayer {
    private List<LazyLoadBase<IModelLayer>> modelLayerList;
    public final List<IModelLayerPredicate> predicateList = Lists.newLinkedList();

    public CompoundModelLayer(List<LazyLoadBase<IModelLayer>> modelLayerList) {
        this.modelLayerList = modelLayerList;
    }

    public CompoundModelLayer(LazyLoadBase<IModelLayer> ... layers) {
        this.modelLayerList = Arrays.asList(layers);
    }

    public void render(IModelLayerContext context, IEntityRenderer entityRenderer, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        for (LazyLoadBase<IModelLayer> layers : this.modelLayerList) {
            if (layers.func_179281_c() == null || !((IModelLayer)layers.func_179281_c()).isActive(context)) continue;
            ((IModelLayer)layers.func_179281_c()).render(context, entityRenderer, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
        }
    }

    @Override
    public boolean isActive(IModelLayerContext context) {
        return ModelLayerManager.arePredicatesFulFilled(this.predicateList, context);
    }

    @Override
    public CompoundModelLayer addPredicate(IModelLayerPredicate predicate) {
        this.predicateList.add(predicate);
        return this;
    }

    public static CompoundModelLayer parse(JsonObject json) {
        LinkedList modelLayers = Lists.newLinkedList();
        JsonArray jsonArray = JSONUtils.func_151214_t((JsonObject)json, (String)"layers");
        int i = 0;
        while (i < jsonArray.size()) {
            int finalI = i++;
            modelLayers.add(new LazyLoadBase(() -> ModelLayerManager.parseLayer(jsonArray.get(finalI))));
        }
        return new CompoundModelLayer(modelLayers);
    }
}

