/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.renderer.entity.modellayer;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayer;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayerContext;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayerProvider;
import net.threetag.threecore.client.renderer.entity.modellayer.ModelLayerContext;

@Mod.EventBusSubscriber(modid="threecore", value={Dist.CLIENT})
public class ModelLayerRenderer<T extends LivingEntity, M extends BipedModel<T>, A extends BipedModel<T>>
extends LayerRenderer<T, M> {
    private static ArrayList<Class<? extends LivingEntity>> entitiesWithLayer = new ArrayList();

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void renderEntityPre(RenderLivingEvent.Pre e) {
        if (!entitiesWithLayer.contains(e.getEntity().getClass())) {
            e.getRenderer().func_177094_a(new ModelLayerRenderer(e.getRenderer()));
            entitiesWithLayer.add(e.getEntity().getClass());
        }
    }

    public ModelLayerRenderer(IEntityRenderer<T, M> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(T entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.renderItemLayers(entityIn, EquipmentSlotType.HEAD, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
        this.renderItemLayers(entityIn, EquipmentSlotType.CHEST, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
        this.renderItemLayers(entityIn, EquipmentSlotType.LEGS, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
        this.renderItemLayers(entityIn, EquipmentSlotType.FEET, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
        ModelLayerContext context = new ModelLayerContext((Entity)entityIn);
        for (Ability ability : AbilityHelper.getAbilities(entityIn)) {
            if (!(ability instanceof IModelLayerProvider) || !ability.getConditionManager().isEnabled()) continue;
            this.renderLayers((IModelLayerProvider)((Object)ability), context, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
        }
    }

    public void renderItemLayers(T entity, EquipmentSlotType slot, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        ItemStack stack = entity.func_184582_a(slot);
        ModelLayerContext context = new ModelLayerContext((LivingEntity)entity, stack, slot);
        if (stack.func_77973_b() instanceof IModelLayerProvider) {
            for (IModelLayer layer : ((IModelLayerProvider)stack.func_77973_b()).getModelLayers(context)) {
                if (!layer.isActive(context)) continue;
                GlStateManager.pushMatrix();
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                layer.render(context, this.field_215335_a, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
                GlStateManager.popMatrix();
            }
        }
    }

    public void renderLayers(IModelLayerProvider provider, IModelLayerContext context, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        for (IModelLayer layer : provider.getModelLayers(context)) {
            if (!layer.isActive(context)) continue;
            GlStateManager.pushMatrix();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            layer.render(context, this.field_215335_a, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
            GlStateManager.popMatrix();
        }
    }

    public boolean func_177142_b() {
        return false;
    }
}

