/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.renderer.entity.modellayer.predicates;

import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayerContext;
import net.threetag.threecore.client.renderer.entity.modellayer.predicates.IModelLayerPredicate;

public class ItemDurabilityPredicate
implements IModelLayerPredicate {
    public final float min;
    public final float max;

    public ItemDurabilityPredicate(float min, float max) {
        this.min = MathHelper.func_76131_a((float)min, (float)0.0f, (float)1.0f);
        this.max = MathHelper.func_76131_a((float)max, (float)0.0f, (float)1.0f);
        if (min > max) {
            throw new IllegalStateException("Min damage value cant be bigger than max damage value!");
        }
    }

    @Override
    public boolean test(IModelLayerContext context) {
        ItemStack stack = context.getAsItem();
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        float dmg = 1.0f - (float)stack.func_77952_i() / (float)stack.func_77958_k();
        return dmg >= this.min && dmg <= this.max;
    }
}

